package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputDataMessage.OutputDataMessageList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputDataMessageList.Builder()}.
 */
@Generated(from = "OutputDataMessage.OutputDataMessageList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOutputDataMessageList
    implements OutputDataMessage.OutputDataMessageList {
  private final @Nullable OutputDataMessage[] messages;

  private ImmutableOutputDataMessageList(@Nullable OutputDataMessage[] messages) {
    this.messages = messages;
  }

  /**
   * @return A cloned {@code messages} array
   */
  @JsonProperty("messages")
  @Override
  public @Nullable OutputDataMessage[] messages() {
    return messages;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OutputDataMessage.OutputDataMessageList#messages() messages}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for messages
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutputDataMessageList withMessages(@Nullable OutputDataMessage... elements) {
    @Nullable OutputDataMessage[] newValue = elements == null ? null : elements.clone();
    return new ImmutableOutputDataMessageList(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputDataMessageList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputDataMessageList
        && equalTo((ImmutableOutputDataMessageList) another);
  }

  private boolean equalTo(ImmutableOutputDataMessageList another) {
    return Arrays.equals(messages, another.messages);
  }

  /**
   * Computes a hash code from attributes: {@code messages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(messages);
    return h;
  }

  /**
   * Prints the immutable value {@code OutputDataMessageList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputDataMessageList{"
        + "messages=" + Arrays.toString(messages)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputDataMessage.OutputDataMessageList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputDataMessageList instance
   */
  public static ImmutableOutputDataMessageList copyOf(OutputDataMessage.OutputDataMessageList instance) {
    if (instance instanceof ImmutableOutputDataMessageList) {
      return (ImmutableOutputDataMessageList) instance;
    }
    return new ImmutableOutputDataMessageList.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputDataMessageList ImmutableOutputDataMessageList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputDataMessage.OutputDataMessageList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable OutputDataMessage[] messages;

    /**
     * Creates a builder for {@link ImmutableOutputDataMessageList ImmutableOutputDataMessageList} instances.
     * <pre>
     * new ImmutableOutputDataMessageList.Builder()
     *    .messages(com.telenordigital.nbiot.OutputDataMessage[] | null) // nullable {@link OutputDataMessage.OutputDataMessageList#messages() messages}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OutputDataMessageList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputDataMessage.OutputDataMessageList instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable OutputDataMessage[] messagesValue = instance.messages();
      if (messagesValue != null) {
        messages(messagesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessage.OutputDataMessageList#messages() messages} attribute.
     * @param messages The elements for messages
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("messages")
    public final Builder messages(OutputDataMessage... messages) {
      this.messages = messages;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputDataMessageList ImmutableOutputDataMessageList}.
     * @return An immutable instance of OutputDataMessageList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputDataMessageList build() {
      return new ImmutableOutputDataMessageList(messages);
    }
  }
}
