/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.telenordigital.nbiot.ClientException;
import com.telenordigital.nbiot.Collection;
import com.telenordigital.nbiot.Config;
import com.telenordigital.nbiot.DataSearchParameters;
import com.telenordigital.nbiot.Device;
import com.telenordigital.nbiot.ImmutableDataSearchParameters;
import com.telenordigital.nbiot.ImmutableOutputDataMessage;
import com.telenordigital.nbiot.Output;
import com.telenordigital.nbiot.OutputDataMessage;
import com.telenordigital.nbiot.OutputDataMessageInternal;
import com.telenordigital.nbiot.OutputStreamHandler;
import com.telenordigital.nbiot.Team;
import com.telenordigital.nbiot.WebSocketHandler;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private static final String TOKEN_HEADER = "X-API-Token";
    private final String endpoint;
    private final String token;
    public final DataSearchParameters DEFAULT_DATA_SEARCH_PARAMS = new ImmutableDataSearchParameters.Builder().limit(255).since(null).until(null).build();

    public Client() throws ClientException {
        Config cfg = new Config();
        this.token = cfg.token();
        this.endpoint = cfg.endpoint();
        this.ping();
    }

    public Client(String endpoint, String token) {
        this.endpoint = endpoint;
        this.token = token;
    }

    private void ping() throws ClientException {
        try {
            HttpResponse resp = Unirest.get((String)(this.endpoint + "/")).header(TOKEN_HEADER, this.token).asString();
            if (resp.getStatus() == 403) {
                throw new ClientException((String)resp.getBody(), resp.getStatus());
            }
        }
        catch (UnirestException ex) {
            throw new ClientException(ex);
        }
    }

    private <T> T get(String path, Class<T> cls) throws ClientException {
        try {
            return (T)Unirest.get((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).asObject(cls).getBody();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    private OutputDataMessageInternal.OutputDataMessageListInternal getData(String path, DataSearchParameters parameters) throws ClientException {
        try {
            Instant since = parameters.since();
            Instant until = parameters.until();
            return (OutputDataMessageInternal.OutputDataMessageListInternal)Unirest.get((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).queryString("limit", (Object)parameters.limit()).queryString("since", since != null ? Long.valueOf(since.toEpochMilli()) : null).queryString("until", until != null ? Long.valueOf(until.toEpochMilli()) : null).asObject(OutputDataMessageInternal.OutputDataMessageListInternal.class).getBody();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    private <T> T create(String path, T template, Class<T> cls) throws ClientException {
        try {
            return (T)Unirest.post((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).body(template).asObject(cls).getBody();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    private <T> T update(String path, T updated, Class<T> cls) throws ClientException {
        try {
            return (T)Unirest.patch((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).body(updated).asObject(cls).getBody();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    private void delete(String path) throws ClientException {
        try {
            Unirest.delete((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).asString();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    public Team team(String teamID) throws ClientException {
        return this.get("/teams/" + teamID, Team.class);
    }

    public Team[] teams() throws ClientException {
        return this.get("/teams", Team.TeamList.class).teams();
    }

    public Team createTeam(Team template) throws ClientException {
        return this.create("/teams", template, Team.class);
    }

    public Team updateTeam(Team team) throws ClientException {
        return this.update("/teams/" + team.id(), team, Team.class);
    }

    public void deleteTeam(String teamID) throws ClientException {
        this.delete("/teams/" + teamID);
    }

    public Collection collection(String collectionID) throws ClientException {
        return this.get("/collections/" + collectionID, Collection.class);
    }

    public Collection[] collections() throws ClientException {
        return this.get("/collections", Collection.CollectionList.class).collections();
    }

    public Collection createCollection(Collection template) throws ClientException {
        return this.create("/collections", template, Collection.class);
    }

    public Collection updateCollection(Collection collection) throws ClientException {
        return this.update("/collections/" + collection.id(), collection, Collection.class);
    }

    public void deleteCollection(String collectionID) throws ClientException {
        this.delete("/collections/" + collectionID);
    }

    public OutputDataMessage[] data(String collectionID) throws ClientException {
        OutputDataMessageInternal[] internalDataMessageList = this.getData("/collections/" + collectionID + "/data", this.DEFAULT_DATA_SEARCH_PARAMS).messages();
        return this.mapDataMessagesFromInternal(internalDataMessageList);
    }

    public OutputDataMessage[] data(String collectionID, DataSearchParameters parameters) throws ClientException {
        OutputDataMessageInternal[] internalDataMessageList = this.getData("/collections/" + collectionID + "/data", parameters).messages();
        return this.mapDataMessagesFromInternal(internalDataMessageList);
    }

    public Device device(String collectionID, String deviceID) throws ClientException {
        return this.get("/collections/" + collectionID + "/devices/" + deviceID, Device.class);
    }

    public Device[] devices(String collectionID) throws ClientException {
        return this.get("/collections/" + collectionID + "/devices", Device.DeviceList.class).devices();
    }

    public Device createDevice(String collectionID, Device template) throws ClientException {
        return this.create("/collections/" + collectionID + "/devices", template, Device.class);
    }

    public Device updateDevice(String collectionID, Device device) throws ClientException {
        return this.update("/collections/" + collectionID + "/devices/" + device.id(), device, Device.class);
    }

    public void deleteDevice(String collectionID, String deviceID) throws ClientException {
        this.delete("/collections/" + collectionID + "/devices/" + deviceID);
    }

    public OutputDataMessage[] data(String collectionID, String deviceId) throws ClientException {
        OutputDataMessageInternal[] internalDataMessageList = this.getData("/collections/" + collectionID + "/devices/" + deviceId + "/data", this.DEFAULT_DATA_SEARCH_PARAMS).messages();
        return this.mapDataMessagesFromInternal(internalDataMessageList);
    }

    public OutputDataMessage[] data(String collectionID, String deviceId, DataSearchParameters parameters) throws ClientException {
        OutputDataMessageInternal[] internalDataMessageList = this.getData("/collections/" + collectionID + "/devices/" + deviceId + "/data", parameters).messages();
        return this.mapDataMessagesFromInternal(internalDataMessageList);
    }

    public Output output(String collectionID, String outputID) throws ClientException {
        return this.get("/collections/" + collectionID + "/outputs/" + outputID, Output.class);
    }

    public Output[] outputs(String collectionID) throws ClientException {
        return this.get("/collections/" + collectionID + "/outputs", Output.OutputList.class).outputs();
    }

    public Output createOutput(String collectionID, Output template) throws ClientException {
        return this.create("/collections/" + collectionID + "/outputs", template, Output.class);
    }

    public Output updateOutput(String collectionID, Output output) throws ClientException {
        return this.update("/collections/" + collectionID + "/outputs/" + output.id(), output, Output.class);
    }

    public void deleteOutput(String collectionID, String outputID) throws ClientException {
        this.delete("/collections/" + collectionID + "/outputs/" + outputID);
    }

    public WebSocketClient collectionOutput(String collectionID, Consumer<OutputStreamHandler> handler) {
        return this.initiateDataMessageStream("/collections/" + collectionID, handler);
    }

    public WebSocketClient deviceOutput(String collectionID, String deviceID, Consumer<OutputStreamHandler> handler) {
        return this.initiateDataMessageStream("/collections/" + collectionID + "/devices/" + deviceID, handler);
    }

    private WebSocketClient initiateDataMessageStream(String path, Consumer<OutputStreamHandler> handler) {
        WebSocketClient client = new WebSocketClient();
        client.getSslContextFactory().setEndpointIdentificationAlgorithm("HTTPS");
        OutputStreamHandler outputStreamHandler = new OutputStreamHandler();
        try {
            client.start();
            URI endpointURI = new URI(this.endpoint);
            String scheme = "wss";
            if (endpointURI.getScheme().equals("http")) {
                scheme = "ws";
            }
            URI uri = new URI(scheme, null, endpointURI.getHost(), endpointURI.getPort(), path + "/from", null, null);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.setHeader(TOKEN_HEADER, this.token);
            handler.accept(outputStreamHandler);
            client.connect((Object)new WebSocketHandler(outputStreamHandler), uri, request);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to set up websocket.", e);
        }
        return client;
    }

    private OutputDataMessage[] mapDataMessagesFromInternal(OutputDataMessageInternal[] internalMessages) {
        return (OutputDataMessage[])Stream.of(internalMessages).map(internalDataMessage -> new ImmutableOutputDataMessage.Builder().device(internalDataMessage.device()).payload(internalDataMessage.payload()).received(Instant.ofEpochMilli(internalDataMessage.received())).build()).toArray(OutputDataMessage[]::new);
    }

    static {
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){
            private ObjectMapper jacksonObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)this.jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return this.jacksonObjectMapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

