/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.telenordigital.nbiot.ImmutableOutputDataMessage;
import com.telenordigital.nbiot.OutputDataMessageInternal;
import com.telenordigital.nbiot.OutputStreamHandler;
import java.io.IOException;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket(maxTextMessageSize=65536)
public class WebSocketHandler {
    private static final Logger logger = Logger.getLogger(WebSocketHandler.class.getName());
    private ObjectMapper jacksonObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private Session session;
    OutputStreamHandler handler;

    public WebSocketHandler(OutputStreamHandler handler) {
        this.handler = handler;
    }

    @OnWebSocketClose
    public void onWebsocketClose(int statusCode, String reason) {
        if (this.handler.closeHandler != null) {
            this.handler.closeHandler.handle(statusCode, reason);
        } else {
            logger.log(Level.INFO, "Connection closed: \nStatus code:" + statusCode + "\nReason:" + reason);
        }
        this.session = null;
    }

    @OnWebSocketConnect
    public void onWebsocketConnect(Session session) {
        this.session = session;
        if (this.handler.connectHandler != null) {
            this.handler.connectHandler.handle(session);
        } else {
            logger.log(Level.INFO, "Connected with websocket");
        }
    }

    @OnWebSocketMessage
    public void onWebsocketMessage(String msg) {
        try {
            OutputDataMessageInternal msgInternal = (OutputDataMessageInternal)this.jacksonObjectMapper.readValue(msg, OutputDataMessageInternal.class);
            if (msgInternal.type().equals("data")) {
                ImmutableOutputDataMessage outputDataMessage = new ImmutableOutputDataMessage.Builder().device(msgInternal.device()).payload(msgInternal.payload()).received(Instant.ofEpochMilli(msgInternal.received())).build();
                if (this.handler.messageHandler != null) {
                    this.handler.messageHandler.handle(outputDataMessage);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error parsing message", e);
            logger.log(Level.WARNING, "Message was: " + msg);
        }
    }

    @OnWebSocketError
    public void onWebsocketError(Throwable error) {
        if (this.handler.errorHandler != null) {
            this.handler.errorHandler.handle(this.session, error);
        } else {
            logger.log(Level.WARNING, "Websocket error", error);
        }
    }
}

