package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BroadcastResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableBroadcastResult.Builder()}.
 */
@Generated(from = "BroadcastResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBroadcastResult implements BroadcastResult {
  private final int sent;
  private final int failed;
  private final BroadcastResult.Error[] errors;

  private ImmutableBroadcastResult(int sent, int failed, BroadcastResult.Error[] errors) {
    this.sent = sent;
    this.failed = failed;
    this.errors = errors;
  }

  /**
   * The number of sent messages.
   */
  @JsonProperty("sent")
  @Override
  public int sent() {
    return sent;
  }

  /**
   * The number of failed messages.
   */
  @JsonProperty("failed")
  @Override
  public int failed() {
    return failed;
  }

  /**
   * Any errors.
   */
  @JsonProperty("errors")
  @Override
  public BroadcastResult.Error[] errors() {
    return errors.clone();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BroadcastResult#sent() sent} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sent
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBroadcastResult withSent(int value) {
    if (this.sent == value) return this;
    return new ImmutableBroadcastResult(value, this.failed, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BroadcastResult#failed() failed} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for failed
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBroadcastResult withFailed(int value) {
    if (this.failed == value) return this;
    return new ImmutableBroadcastResult(this.sent, value, this.errors);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BroadcastResult#errors() errors}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for errors
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBroadcastResult withErrors(BroadcastResult.Error... elements) {
    BroadcastResult.Error[] newValue = elements.clone();
    return new ImmutableBroadcastResult(this.sent, this.failed, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBroadcastResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBroadcastResult
        && equalTo((ImmutableBroadcastResult) another);
  }

  private boolean equalTo(ImmutableBroadcastResult another) {
    return sent == another.sent
        && failed == another.failed
        && Arrays.equals(errors, another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code sent}, {@code failed}, {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + sent;
    h += (h << 5) + failed;
    h += (h << 5) + Arrays.hashCode(errors);
    return h;
  }

  /**
   * Prints the immutable value {@code BroadcastResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BroadcastResult{"
        + "sent=" + sent
        + ", failed=" + failed
        + ", errors=" + Arrays.toString(errors)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link BroadcastResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BroadcastResult instance
   */
  public static ImmutableBroadcastResult copyOf(BroadcastResult instance) {
    if (instance instanceof ImmutableBroadcastResult) {
      return (ImmutableBroadcastResult) instance;
    }
    return new ImmutableBroadcastResult.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableBroadcastResult ImmutableBroadcastResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BroadcastResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SENT = 0x1L;
    private static final long INIT_BIT_FAILED = 0x2L;
    private static final long INIT_BIT_ERRORS = 0x4L;
    private long initBits = 0x7L;

    private int sent;
    private int failed;
    private @Nullable BroadcastResult.Error[] errors;

    /**
     * Creates a builder for {@link ImmutableBroadcastResult ImmutableBroadcastResult} instances.
     * <pre>
     * new ImmutableBroadcastResult.Builder()
     *    .sent(int) // required {@link BroadcastResult#sent() sent}
     *    .failed(int) // required {@link BroadcastResult#failed() failed}
     *    .errors(com.telenordigital.nbiot.BroadcastResult.Error) // required {@link BroadcastResult#errors() errors}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BroadcastResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BroadcastResult instance) {
      Objects.requireNonNull(instance, "instance");
      sent(instance.sent());
      failed(instance.failed());
      errors(instance.errors());
      return this;
    }

    /**
     * Initializes the value for the {@link BroadcastResult#sent() sent} attribute.
     * @param sent The value for sent 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sent")
    public final Builder sent(int sent) {
      this.sent = sent;
      initBits &= ~INIT_BIT_SENT;
      return this;
    }

    /**
     * Initializes the value for the {@link BroadcastResult#failed() failed} attribute.
     * @param failed The value for failed 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("failed")
    public final Builder failed(int failed) {
      this.failed = failed;
      initBits &= ~INIT_BIT_FAILED;
      return this;
    }

    /**
     * Initializes the value for the {@link BroadcastResult#errors() errors} attribute.
     * @param errors The elements for errors
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    public final Builder errors(BroadcastResult.Error... errors) {
      this.errors = errors.clone();
      initBits &= ~INIT_BIT_ERRORS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBroadcastResult ImmutableBroadcastResult}.
     * @return An immutable instance of BroadcastResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBroadcastResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBroadcastResult(sent, failed, errors);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SENT) != 0) attributes.add("sent");
      if ((initBits & INIT_BIT_FAILED) != 0) attributes.add("failed");
      if ((initBits & INIT_BIT_ERRORS) != 0) attributes.add("errors");
      return "Cannot build BroadcastResult, some of required attributes are not set " + attributes;
    }
  }
}
