package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Collection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableCollection.Builder()}.
 */
@Generated(from = "Collection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCollection implements Collection {
  private final @Nullable String id;
  private final @Nullable String teamID;
  private final @Nullable FieldMask fieldMask;
  private final @Nullable Map<String, String> tags;

  private ImmutableCollection(
      @Nullable String id,
      @Nullable String teamID,
      @Nullable FieldMask fieldMask,
      @Nullable Map<String, String> tags) {
    this.id = id;
    this.teamID = teamID;
    this.fieldMask = fieldMask;
    this.tags = tags;
  }

  /**
   * The collection's ID
   */
  @JsonProperty("collectionId")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * The team's ID
   */
  @JsonProperty("teamId")
  @Override
  public @Nullable String teamID() {
    return teamID;
  }

  /**
   * The field mask
   */
  @JsonProperty("fieldMask")
  @Override
  public @Nullable FieldMask fieldMask() {
    return fieldMask;
  }

  /**
   * Collection tags.
   */
  @JsonProperty("tags")
  @Override
  public @Nullable Map<String, String> tags() {
    return tags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Collection#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollection withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableCollection(value, this.teamID, this.fieldMask, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Collection#teamID() teamID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for teamID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollection withTeamID(@Nullable String value) {
    if (Objects.equals(this.teamID, value)) return this;
    return new ImmutableCollection(this.id, value, this.fieldMask, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Collection#fieldMask() fieldMask} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldMask (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCollection withFieldMask(@Nullable FieldMask value) {
    if (this.fieldMask == value) return this;
    return new ImmutableCollection(this.id, this.teamID, value, this.tags);
  }

  /**
   * Copy the current immutable object by replacing the {@link Collection#tags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCollection withTags(@Nullable Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableCollection(this.id, this.teamID, this.fieldMask, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCollection
        && equalTo((ImmutableCollection) another);
  }

  private boolean equalTo(ImmutableCollection another) {
    return Objects.equals(id, another.id)
        && Objects.equals(teamID, another.teamID)
        && Objects.equals(fieldMask, another.fieldMask)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code teamID}, {@code fieldMask}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(teamID);
    h += (h << 5) + Objects.hashCode(fieldMask);
    h += (h << 5) + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code Collection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Collection{"
        + "id=" + id
        + ", teamID=" + teamID
        + ", fieldMask=" + fieldMask
        + ", tags=" + tags
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Collection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Collection instance
   */
  public static ImmutableCollection copyOf(Collection instance) {
    if (instance instanceof ImmutableCollection) {
      return (ImmutableCollection) instance;
    }
    return new ImmutableCollection.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCollection ImmutableCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Collection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String teamID;
    private @Nullable FieldMask fieldMask;
    private Map<String, String> tags = null;

    /**
     * Creates a builder for {@link ImmutableCollection ImmutableCollection} instances.
     * <pre>
     * new ImmutableCollection.Builder()
     *    .id(String | null) // nullable {@link Collection#id() id}
     *    .teamID(String | null) // nullable {@link Collection#teamID() teamID}
     *    .fieldMask(com.telenordigital.nbiot.FieldMask | null) // nullable {@link Collection#fieldMask() fieldMask}
     *    .tags(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link Collection#tags() tags}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Collection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Collection instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String teamIDValue = instance.teamID();
      if (teamIDValue != null) {
        teamID(teamIDValue);
      }
      @Nullable FieldMask fieldMaskValue = instance.fieldMask();
      if (fieldMaskValue != null) {
        fieldMask(fieldMaskValue);
      }
      @Nullable Map<String, String> tagsValue = instance.tags();
      if (tagsValue != null) {
        putAllTags(tagsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Collection#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("collectionId")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Collection#teamID() teamID} attribute.
     * @param teamID The value for teamID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("teamId")
    public final Builder teamID(@Nullable String teamID) {
      this.teamID = teamID;
      return this;
    }

    /**
     * Initializes the value for the {@link Collection#fieldMask() fieldMask} attribute.
     * @param fieldMask The value for fieldMask (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fieldMask")
    public final Builder fieldMask(@Nullable FieldMask fieldMask) {
      this.fieldMask = fieldMask;
      return this;
    }

    /**
     * Put one entry to the {@link Collection#tags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(String key, String value) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link Collection#tags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Collection#tags() tags} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tags = null;
        return this;
      }
      this.tags = new LinkedHashMap<String, String>();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Collection#tags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCollection ImmutableCollection}.
     * @return An immutable instance of Collection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCollection build() {
      return new ImmutableCollection(id, teamID, fieldMask, tags == null ? null : createUnmodifiableMap(false, false, tags));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
