package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Collection.CollectionList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableCollectionList.Builder()}.
 */
@Generated(from = "Collection.CollectionList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCollectionList implements Collection.CollectionList {
  private final @Nullable Collection[] collections;

  private ImmutableCollectionList(@Nullable Collection[] collections) {
    this.collections = collections;
  }

  /**
   * @return A cloned {@code collections} array
   */
  @JsonProperty("collections")
  @Override
  public @Nullable Collection[] collections() {
    return collections;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Collection.CollectionList#collections() collections}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for collections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCollectionList withCollections(@Nullable Collection... elements) {
    @Nullable Collection[] newValue = elements == null ? null : elements.clone();
    return new ImmutableCollectionList(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCollectionList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCollectionList
        && equalTo((ImmutableCollectionList) another);
  }

  private boolean equalTo(ImmutableCollectionList another) {
    return Arrays.equals(collections, another.collections);
  }

  /**
   * Computes a hash code from attributes: {@code collections}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(collections);
    return h;
  }

  /**
   * Prints the immutable value {@code CollectionList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CollectionList{"
        + "collections=" + Arrays.toString(collections)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Collection.CollectionList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CollectionList instance
   */
  public static ImmutableCollectionList copyOf(Collection.CollectionList instance) {
    if (instance instanceof ImmutableCollectionList) {
      return (ImmutableCollectionList) instance;
    }
    return new ImmutableCollectionList.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCollectionList ImmutableCollectionList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Collection.CollectionList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Collection[] collections;

    /**
     * Creates a builder for {@link ImmutableCollectionList ImmutableCollectionList} instances.
     * <pre>
     * new ImmutableCollectionList.Builder()
     *    .collections(com.telenordigital.nbiot.Collection[] | null) // nullable {@link Collection.CollectionList#collections() collections}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CollectionList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Collection.CollectionList instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Collection[] collectionsValue = instance.collections();
      if (collectionsValue != null) {
        collections(collectionsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Collection.CollectionList#collections() collections} attribute.
     * @param collections The elements for collections
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("collections")
    public final Builder collections(Collection... collections) {
      this.collections = collections;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCollectionList ImmutableCollectionList}.
     * @return An immutable instance of CollectionList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCollectionList build() {
      return new ImmutableCollectionList(collections);
    }
  }
}
