package com.telenordigital.nbiot;

import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DataSearchParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableDataSearchParameters.Builder()}.
 */
@Generated(from = "DataSearchParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDataSearchParameters implements DataSearchParameters {
  private final @Nullable Integer limit;
  private final @Nullable Instant since;
  private final @Nullable Instant until;

  private ImmutableDataSearchParameters(
      @Nullable Integer limit,
      @Nullable Instant since,
      @Nullable Instant until) {
    this.limit = limit;
    this.since = since;
    this.until = until;
  }

  /**
   * Limit number of results when querying data endpoint
   * @return Limit parameter as an Integer
   */
  @Override
  public @Nullable Integer limit() {
    return limit;
  }

  /**
   * Fetch data since given Instant
   * @return Since parameter as Instant
   */
  @Override
  public @Nullable Instant since() {
    return since;
  }

  /**
   * Fetch data until given Instant
   * @return Until parameter as Instant
   */
  @Override
  public @Nullable Instant until() {
    return until;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSearchParameters#limit() limit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for limit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSearchParameters withLimit(@Nullable Integer value) {
    if (Objects.equals(this.limit, value)) return this;
    return new ImmutableDataSearchParameters(value, this.since, this.until);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSearchParameters#since() since} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for since (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSearchParameters withSince(@Nullable Instant value) {
    if (this.since == value) return this;
    return new ImmutableDataSearchParameters(this.limit, value, this.until);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataSearchParameters#until() until} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for until (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataSearchParameters withUntil(@Nullable Instant value) {
    if (this.until == value) return this;
    return new ImmutableDataSearchParameters(this.limit, this.since, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataSearchParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataSearchParameters
        && equalTo((ImmutableDataSearchParameters) another);
  }

  private boolean equalTo(ImmutableDataSearchParameters another) {
    return Objects.equals(limit, another.limit)
        && Objects.equals(since, another.since)
        && Objects.equals(until, another.until);
  }

  /**
   * Computes a hash code from attributes: {@code limit}, {@code since}, {@code until}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(limit);
    h += (h << 5) + Objects.hashCode(since);
    h += (h << 5) + Objects.hashCode(until);
    return h;
  }

  /**
   * Prints the immutable value {@code DataSearchParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataSearchParameters{"
        + "limit=" + limit
        + ", since=" + since
        + ", until=" + until
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DataSearchParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataSearchParameters instance
   */
  public static ImmutableDataSearchParameters copyOf(DataSearchParameters instance) {
    if (instance instanceof ImmutableDataSearchParameters) {
      return (ImmutableDataSearchParameters) instance;
    }
    return new ImmutableDataSearchParameters.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableDataSearchParameters ImmutableDataSearchParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataSearchParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer limit;
    private @Nullable Instant since;
    private @Nullable Instant until;

    /**
     * Creates a builder for {@link ImmutableDataSearchParameters ImmutableDataSearchParameters} instances.
     * <pre>
     * new ImmutableDataSearchParameters.Builder()
     *    .limit(Integer | null) // nullable {@link DataSearchParameters#limit() limit}
     *    .since(java.time.Instant | null) // nullable {@link DataSearchParameters#since() since}
     *    .until(java.time.Instant | null) // nullable {@link DataSearchParameters#until() until}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataSearchParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataSearchParameters instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer limitValue = instance.limit();
      if (limitValue != null) {
        limit(limitValue);
      }
      @Nullable Instant sinceValue = instance.since();
      if (sinceValue != null) {
        since(sinceValue);
      }
      @Nullable Instant untilValue = instance.until();
      if (untilValue != null) {
        until(untilValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataSearchParameters#limit() limit} attribute.
     * @param limit The value for limit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder limit(@Nullable Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSearchParameters#since() since} attribute.
     * @param since The value for since (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder since(@Nullable Instant since) {
      this.since = since;
      return this;
    }

    /**
     * Initializes the value for the {@link DataSearchParameters#until() until} attribute.
     * @param until The value for until (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder until(@Nullable Instant until) {
      this.until = until;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataSearchParameters ImmutableDataSearchParameters}.
     * @return An immutable instance of DataSearchParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataSearchParameters build() {
      return new ImmutableDataSearchParameters(limit, since, until);
    }
  }
}
