package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Device}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableDevice.Builder()}.
 */
@Generated(from = "Device", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDevice implements Device {
  private final @Nullable String id;
  private final @Nullable String collectionID;
  private final @Nullable String imei;
  private final @Nullable String imsi;
  private final @Nullable Map<String, String> tags;

  private ImmutableDevice(
      @Nullable String id,
      @Nullable String collectionID,
      @Nullable String imei,
      @Nullable String imsi,
      @Nullable Map<String, String> tags) {
    this.id = id;
    this.collectionID = collectionID;
    this.imei = imei;
    this.imsi = imsi;
    this.tags = tags;
  }

  /**
   * The device's EUI.
   */
  @JsonProperty("deviceId")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * The collection the device belongs to.
   */
  @JsonProperty("collectionId")
  @Override
  public @Nullable String collectionID() {
    return collectionID;
  }

  /**
   * The device's IMEI.
   */
  @JsonProperty("imei")
  @Override
  public @Nullable String imei() {
    return imei;
  }

  /**
   * The device's IMSI.
   */
  @JsonProperty("imsi")
  @Override
  public @Nullable String imsi() {
    return imsi;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public @Nullable Map<String, String> tags() {
    return tags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Device#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDevice withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableDevice(value, this.collectionID, this.imei, this.imsi, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Device#collectionID() collectionID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDevice withCollectionID(@Nullable String value) {
    if (Objects.equals(this.collectionID, value)) return this;
    return new ImmutableDevice(this.id, value, this.imei, this.imsi, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Device#imei() imei} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for imei (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDevice withImei(@Nullable String value) {
    if (Objects.equals(this.imei, value)) return this;
    return new ImmutableDevice(this.id, this.collectionID, value, this.imsi, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Device#imsi() imsi} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for imsi (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDevice withImsi(@Nullable String value) {
    if (Objects.equals(this.imsi, value)) return this;
    return new ImmutableDevice(this.id, this.collectionID, this.imei, value, this.tags);
  }

  /**
   * Copy the current immutable object by replacing the {@link Device#tags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDevice withTags(@Nullable Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableDevice(this.id, this.collectionID, this.imei, this.imsi, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDevice} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDevice
        && equalTo((ImmutableDevice) another);
  }

  private boolean equalTo(ImmutableDevice another) {
    return Objects.equals(id, another.id)
        && Objects.equals(collectionID, another.collectionID)
        && Objects.equals(imei, another.imei)
        && Objects.equals(imsi, another.imsi)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code collectionID}, {@code imei}, {@code imsi}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(collectionID);
    h += (h << 5) + Objects.hashCode(imei);
    h += (h << 5) + Objects.hashCode(imsi);
    h += (h << 5) + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code Device} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Device{"
        + "id=" + id
        + ", collectionID=" + collectionID
        + ", imei=" + imei
        + ", imsi=" + imsi
        + ", tags=" + tags
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Device} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Device instance
   */
  public static ImmutableDevice copyOf(Device instance) {
    if (instance instanceof ImmutableDevice) {
      return (ImmutableDevice) instance;
    }
    return new ImmutableDevice.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableDevice ImmutableDevice}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Device", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String collectionID;
    private @Nullable String imei;
    private @Nullable String imsi;
    private Map<String, String> tags = null;

    /**
     * Creates a builder for {@link ImmutableDevice ImmutableDevice} instances.
     * <pre>
     * new ImmutableDevice.Builder()
     *    .id(String | null) // nullable {@link Device#id() id}
     *    .collectionID(String | null) // nullable {@link Device#collectionID() collectionID}
     *    .imei(String | null) // nullable {@link Device#imei() imei}
     *    .imsi(String | null) // nullable {@link Device#imsi() imsi}
     *    .tags(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link Device#tags() tags}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Device} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Device instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String collectionIDValue = instance.collectionID();
      if (collectionIDValue != null) {
        collectionID(collectionIDValue);
      }
      @Nullable String imeiValue = instance.imei();
      if (imeiValue != null) {
        imei(imeiValue);
      }
      @Nullable String imsiValue = instance.imsi();
      if (imsiValue != null) {
        imsi(imsiValue);
      }
      @Nullable Map<String, String> tagsValue = instance.tags();
      if (tagsValue != null) {
        putAllTags(tagsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Device#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("deviceId")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Device#collectionID() collectionID} attribute.
     * @param collectionID The value for collectionID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("collectionId")
    public final Builder collectionID(@Nullable String collectionID) {
      this.collectionID = collectionID;
      return this;
    }

    /**
     * Initializes the value for the {@link Device#imei() imei} attribute.
     * @param imei The value for imei (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("imei")
    public final Builder imei(@Nullable String imei) {
      this.imei = imei;
      return this;
    }

    /**
     * Initializes the value for the {@link Device#imsi() imsi} attribute.
     * @param imsi The value for imsi (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("imsi")
    public final Builder imsi(@Nullable String imsi) {
      this.imsi = imsi;
      return this;
    }

    /**
     * Put one entry to the {@link Device#tags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(String key, String value) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link Device#tags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Device#tags() tags} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tags = null;
        return this;
      }
      this.tags = new LinkedHashMap<String, String>();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Device#tags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDevice ImmutableDevice}.
     * @return An immutable instance of Device
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDevice build() {
      return new ImmutableDevice(id, collectionID, imei, imsi, tags == null ? null : createUnmodifiableMap(false, false, tags));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
