package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DownstreamMessage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableDownstreamMessage.Builder()}.
 */
@Generated(from = "DownstreamMessage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDownstreamMessage implements DownstreamMessage {
  private final int port;
  private final byte[] payload;

  private ImmutableDownstreamMessage(int port, byte[] payload) {
    this.port = port;
    this.payload = payload;
  }

  /**
   * The port to send to.
   */
  @JsonProperty("port")
  @Override
  public int port() {
    return port;
  }

  /**
   * The payload to send.
   */
  @JsonProperty("payload")
  @Override
  public byte[] payload() {
    return payload.clone();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DownstreamMessage#port() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDownstreamMessage withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableDownstreamMessage(value, this.payload);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DownstreamMessage#payload() payload}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for payload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDownstreamMessage withPayload(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutableDownstreamMessage(this.port, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDownstreamMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDownstreamMessage
        && equalTo((ImmutableDownstreamMessage) another);
  }

  private boolean equalTo(ImmutableDownstreamMessage another) {
    return port == another.port
        && Arrays.equals(payload, another.payload);
  }

  /**
   * Computes a hash code from attributes: {@code port}, {@code payload}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + port;
    h += (h << 5) + Arrays.hashCode(payload);
    return h;
  }

  /**
   * Prints the immutable value {@code DownstreamMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DownstreamMessage{"
        + "port=" + port
        + ", payload=" + Arrays.toString(payload)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DownstreamMessage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DownstreamMessage instance
   */
  public static ImmutableDownstreamMessage copyOf(DownstreamMessage instance) {
    if (instance instanceof ImmutableDownstreamMessage) {
      return (ImmutableDownstreamMessage) instance;
    }
    return new ImmutableDownstreamMessage.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableDownstreamMessage ImmutableDownstreamMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DownstreamMessage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PORT = 0x1L;
    private static final long INIT_BIT_PAYLOAD = 0x2L;
    private long initBits = 0x3L;

    private int port;
    private @Nullable byte[] payload;

    /**
     * Creates a builder for {@link ImmutableDownstreamMessage ImmutableDownstreamMessage} instances.
     * <pre>
     * new ImmutableDownstreamMessage.Builder()
     *    .port(int) // required {@link DownstreamMessage#port() port}
     *    .payload(byte) // required {@link DownstreamMessage#payload() payload}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DownstreamMessage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DownstreamMessage instance) {
      Objects.requireNonNull(instance, "instance");
      port(instance.port());
      payload(instance.payload());
      return this;
    }

    /**
     * Initializes the value for the {@link DownstreamMessage#port() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link DownstreamMessage#payload() payload} attribute.
     * @param payload The elements for payload
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("payload")
    public final Builder payload(byte... payload) {
      this.payload = payload.clone();
      initBits &= ~INIT_BIT_PAYLOAD;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDownstreamMessage ImmutableDownstreamMessage}.
     * @return An immutable instance of DownstreamMessage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDownstreamMessage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDownstreamMessage(port, payload);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      if ((initBits & INIT_BIT_PAYLOAD) != 0) attributes.add("payload");
      return "Cannot build DownstreamMessage, some of required attributes are not set " + attributes;
    }
  }
}
