package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BroadcastResult.Error}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableError.Builder()}.
 */
@Generated(from = "BroadcastResult.Error", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableError implements BroadcastResult.Error {
  private final String deviceID;
  private final String message;

  private ImmutableError(String deviceID, String message) {
    this.deviceID = deviceID;
    this.message = message;
  }

  /**
   * The device ID.
   */
  @JsonProperty("deviceId")
  @Override
  public String deviceID() {
    return deviceID;
  }

  /**
   * The message.
   */
  @JsonProperty("message")
  @Override
  public String message() {
    return message;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BroadcastResult.Error#deviceID() deviceID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deviceID
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withDeviceID(String value) {
    String newValue = Objects.requireNonNull(value, "deviceID");
    if (this.deviceID.equals(newValue)) return this;
    return new ImmutableError(newValue, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BroadcastResult.Error#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withMessage(String value) {
    String newValue = Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableError(this.deviceID, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableError
        && equalTo((ImmutableError) another);
  }

  private boolean equalTo(ImmutableError another) {
    return deviceID.equals(another.deviceID)
        && message.equals(another.message);
  }

  /**
   * Computes a hash code from attributes: {@code deviceID}, {@code message}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + deviceID.hashCode();
    h += (h << 5) + message.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Error} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Error{"
        + "deviceID=" + deviceID
        + ", message=" + message
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link BroadcastResult.Error} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Error instance
   */
  public static ImmutableError copyOf(BroadcastResult.Error instance) {
    if (instance instanceof ImmutableError) {
      return (ImmutableError) instance;
    }
    return new ImmutableError.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableError ImmutableError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BroadcastResult.Error", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEVICE_I_D = 0x1L;
    private static final long INIT_BIT_MESSAGE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String deviceID;
    private @Nullable String message;

    /**
     * Creates a builder for {@link ImmutableError ImmutableError} instances.
     * <pre>
     * new ImmutableError.Builder()
     *    .deviceID(String) // required {@link BroadcastResult.Error#deviceID() deviceID}
     *    .message(String) // required {@link BroadcastResult.Error#message() message}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Error} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BroadcastResult.Error instance) {
      Objects.requireNonNull(instance, "instance");
      deviceID(instance.deviceID());
      message(instance.message());
      return this;
    }

    /**
     * Initializes the value for the {@link BroadcastResult.Error#deviceID() deviceID} attribute.
     * @param deviceID The value for deviceID 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("deviceId")
    public final Builder deviceID(String deviceID) {
      this.deviceID = Objects.requireNonNull(deviceID, "deviceID");
      initBits &= ~INIT_BIT_DEVICE_I_D;
      return this;
    }

    /**
     * Initializes the value for the {@link BroadcastResult.Error#message() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableError ImmutableError}.
     * @return An immutable instance of Error
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableError build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableError(deviceID, message);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEVICE_I_D) != 0) attributes.add("deviceID");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      return "Cannot build Error, some of required attributes are not set " + attributes;
    }
  }
}
