package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FieldMask}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableFieldMask.Builder()}.
 */
@Generated(from = "FieldMask", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFieldMask implements FieldMask {
  private final @Nullable Boolean imsi;
  private final @Nullable Boolean imei;
  private final @Nullable Boolean location;
  private final @Nullable Boolean msisdn;

  private ImmutableFieldMask(
      @Nullable Boolean imsi,
      @Nullable Boolean imei,
      @Nullable Boolean location,
      @Nullable Boolean msisdn) {
    this.imsi = imsi;
    this.imei = imei;
    this.location = location;
    this.msisdn = msisdn;
  }

  /**
   * Whether to mask the IMSI.
   */
  @JsonProperty("imsi")
  @Override
  public @Nullable Boolean imsi() {
    return imsi;
  }

  /**
   * Whether to mask the IMEI.
   */
  @JsonProperty("imei")
  @Override
  public @Nullable Boolean imei() {
    return imei;
  }

  /**
   * Whether to mask the location.
   */
  @JsonProperty("location")
  @Override
  public @Nullable Boolean location() {
    return location;
  }

  /**
   * Whether to mask the MSISDN.
   */
  @JsonProperty("msisdn")
  @Override
  public @Nullable Boolean msisdn() {
    return msisdn;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldMask#imsi() imsi} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for imsi (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldMask withImsi(@Nullable Boolean value) {
    if (Objects.equals(this.imsi, value)) return this;
    return new ImmutableFieldMask(value, this.imei, this.location, this.msisdn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldMask#imei() imei} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for imei (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldMask withImei(@Nullable Boolean value) {
    if (Objects.equals(this.imei, value)) return this;
    return new ImmutableFieldMask(this.imsi, value, this.location, this.msisdn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldMask#location() location} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for location (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldMask withLocation(@Nullable Boolean value) {
    if (Objects.equals(this.location, value)) return this;
    return new ImmutableFieldMask(this.imsi, this.imei, value, this.msisdn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldMask#msisdn() msisdn} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for msisdn (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldMask withMsisdn(@Nullable Boolean value) {
    if (Objects.equals(this.msisdn, value)) return this;
    return new ImmutableFieldMask(this.imsi, this.imei, this.location, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldMask} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldMask
        && equalTo((ImmutableFieldMask) another);
  }

  private boolean equalTo(ImmutableFieldMask another) {
    return Objects.equals(imsi, another.imsi)
        && Objects.equals(imei, another.imei)
        && Objects.equals(location, another.location)
        && Objects.equals(msisdn, another.msisdn);
  }

  /**
   * Computes a hash code from attributes: {@code imsi}, {@code imei}, {@code location}, {@code msisdn}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(imsi);
    h += (h << 5) + Objects.hashCode(imei);
    h += (h << 5) + Objects.hashCode(location);
    h += (h << 5) + Objects.hashCode(msisdn);
    return h;
  }

  /**
   * Prints the immutable value {@code FieldMask} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FieldMask{"
        + "imsi=" + imsi
        + ", imei=" + imei
        + ", location=" + location
        + ", msisdn=" + msisdn
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link FieldMask} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FieldMask instance
   */
  public static ImmutableFieldMask copyOf(FieldMask instance) {
    if (instance instanceof ImmutableFieldMask) {
      return (ImmutableFieldMask) instance;
    }
    return new ImmutableFieldMask.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableFieldMask ImmutableFieldMask}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FieldMask", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Boolean imsi;
    private @Nullable Boolean imei;
    private @Nullable Boolean location;
    private @Nullable Boolean msisdn;

    /**
     * Creates a builder for {@link ImmutableFieldMask ImmutableFieldMask} instances.
     * <pre>
     * new ImmutableFieldMask.Builder()
     *    .imsi(Boolean | null) // nullable {@link FieldMask#imsi() imsi}
     *    .imei(Boolean | null) // nullable {@link FieldMask#imei() imei}
     *    .location(Boolean | null) // nullable {@link FieldMask#location() location}
     *    .msisdn(Boolean | null) // nullable {@link FieldMask#msisdn() msisdn}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FieldMask} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldMask instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Boolean imsiValue = instance.imsi();
      if (imsiValue != null) {
        imsi(imsiValue);
      }
      @Nullable Boolean imeiValue = instance.imei();
      if (imeiValue != null) {
        imei(imeiValue);
      }
      @Nullable Boolean locationValue = instance.location();
      if (locationValue != null) {
        location(locationValue);
      }
      @Nullable Boolean msisdnValue = instance.msisdn();
      if (msisdnValue != null) {
        msisdn(msisdnValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FieldMask#imsi() imsi} attribute.
     * @param imsi The value for imsi (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("imsi")
    public final Builder imsi(@Nullable Boolean imsi) {
      this.imsi = imsi;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldMask#imei() imei} attribute.
     * @param imei The value for imei (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("imei")
    public final Builder imei(@Nullable Boolean imei) {
      this.imei = imei;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldMask#location() location} attribute.
     * @param location The value for location (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("location")
    public final Builder location(@Nullable Boolean location) {
      this.location = location;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldMask#msisdn() msisdn} attribute.
     * @param msisdn The value for msisdn (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("msisdn")
    public final Builder msisdn(@Nullable Boolean msisdn) {
      this.msisdn = msisdn;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldMask ImmutableFieldMask}.
     * @return An immutable instance of FieldMask
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldMask build() {
      return new ImmutableFieldMask(imsi, imei, location, msisdn);
    }
  }
}
