package com.telenordigital.nbiot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IFTTTOutput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableIFTTTOutput.Builder()}.
 */
@Generated(from = "IFTTTOutput", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableIFTTTOutput extends IFTTTOutput {
  private final @Nullable String id;
  private final @Nullable String collectionID;
  private final @Nullable Boolean enabled;
  private final @Nullable Map<String, String> tags;
  private final String key;
  private final String eventName;
  private final @Nullable Boolean asIsPayload;

  private ImmutableIFTTTOutput(
      @Nullable String id,
      @Nullable String collectionID,
      @Nullable Boolean enabled,
      @Nullable Map<String, String> tags,
      String key,
      String eventName,
      @Nullable Boolean asIsPayload) {
    this.id = id;
    this.collectionID = collectionID;
    this.enabled = enabled;
    this.tags = tags;
    this.key = key;
    this.eventName = eventName;
    this.asIsPayload = asIsPayload;
  }

  /**
   * The output's ID.
   */
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * The collection the output belongs to.
   */
  @Override
  public @Nullable String collectionID() {
    return collectionID;
  }

  /**
   * Whether the output is enabled.
   */
  @Override
  public @Nullable Boolean enabled() {
    return enabled;
  }

  /**
   * Output tags.
   */
  @Override
  public @Nullable Map<String, String> tags() {
    return tags;
  }

  /**
   * The output's key.
   */
  @Override
  public String key() {
    return key;
  }

  /**
   * The output's eventName.
   */
  @Override
  public String eventName() {
    return eventName;
  }

  /**
   * The output's asIsPayload.
   */
  @Override
  public @Nullable Boolean asIsPayload() {
    return asIsPayload;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IFTTTOutput#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIFTTTOutput withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableIFTTTOutput(value, this.collectionID, this.enabled, this.tags, this.key, this.eventName, this.asIsPayload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IFTTTOutput#collectionID() collectionID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIFTTTOutput withCollectionID(@Nullable String value) {
    if (Objects.equals(this.collectionID, value)) return this;
    return new ImmutableIFTTTOutput(this.id, value, this.enabled, this.tags, this.key, this.eventName, this.asIsPayload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IFTTTOutput#enabled() enabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIFTTTOutput withEnabled(@Nullable Boolean value) {
    if (Objects.equals(this.enabled, value)) return this;
    return new ImmutableIFTTTOutput(this.id, this.collectionID, value, this.tags, this.key, this.eventName, this.asIsPayload);
  }

  /**
   * Copy the current immutable object by replacing the {@link IFTTTOutput#tags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableIFTTTOutput withTags(@Nullable Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableIFTTTOutput(this.id, this.collectionID, this.enabled, newValue, this.key, this.eventName, this.asIsPayload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IFTTTOutput#key() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIFTTTOutput withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableIFTTTOutput(this.id, this.collectionID, this.enabled, this.tags, newValue, this.eventName, this.asIsPayload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IFTTTOutput#eventName() eventName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIFTTTOutput withEventName(String value) {
    String newValue = Objects.requireNonNull(value, "eventName");
    if (this.eventName.equals(newValue)) return this;
    return new ImmutableIFTTTOutput(this.id, this.collectionID, this.enabled, this.tags, this.key, newValue, this.asIsPayload);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IFTTTOutput#asIsPayload() asIsPayload} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for asIsPayload (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIFTTTOutput withAsIsPayload(@Nullable Boolean value) {
    if (Objects.equals(this.asIsPayload, value)) return this;
    return new ImmutableIFTTTOutput(this.id, this.collectionID, this.enabled, this.tags, this.key, this.eventName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIFTTTOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIFTTTOutput
        && equalTo((ImmutableIFTTTOutput) another);
  }

  private boolean equalTo(ImmutableIFTTTOutput another) {
    return Objects.equals(id, another.id)
        && Objects.equals(collectionID, another.collectionID)
        && Objects.equals(enabled, another.enabled)
        && Objects.equals(tags, another.tags)
        && key.equals(another.key)
        && eventName.equals(another.eventName)
        && Objects.equals(asIsPayload, another.asIsPayload);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code collectionID}, {@code enabled}, {@code tags}, {@code key}, {@code eventName}, {@code asIsPayload}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(collectionID);
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + key.hashCode();
    h += (h << 5) + eventName.hashCode();
    h += (h << 5) + Objects.hashCode(asIsPayload);
    return h;
  }

  /**
   * Prints the immutable value {@code IFTTTOutput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IFTTTOutput{"
        + "id=" + id
        + ", collectionID=" + collectionID
        + ", enabled=" + enabled
        + ", tags=" + tags
        + ", key=" + key
        + ", eventName=" + eventName
        + ", asIsPayload=" + asIsPayload
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link IFTTTOutput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IFTTTOutput instance
   */
  public static ImmutableIFTTTOutput copyOf(IFTTTOutput instance) {
    if (instance instanceof ImmutableIFTTTOutput) {
      return (ImmutableIFTTTOutput) instance;
    }
    return new ImmutableIFTTTOutput.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableIFTTTOutput ImmutableIFTTTOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IFTTTOutput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_EVENT_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String collectionID;
    private @Nullable Boolean enabled;
    private Map<String, String> tags = null;
    private @Nullable String key;
    private @Nullable String eventName;
    private @Nullable Boolean asIsPayload;

    /**
     * Creates a builder for {@link ImmutableIFTTTOutput ImmutableIFTTTOutput} instances.
     * <pre>
     * new ImmutableIFTTTOutput.Builder()
     *    .id(String | null) // nullable {@link IFTTTOutput#id() id}
     *    .collectionID(String | null) // nullable {@link IFTTTOutput#collectionID() collectionID}
     *    .enabled(Boolean | null) // nullable {@link IFTTTOutput#enabled() enabled}
     *    .tags(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link IFTTTOutput#tags() tags}
     *    .key(String) // required {@link IFTTTOutput#key() key}
     *    .eventName(String) // required {@link IFTTTOutput#eventName() eventName}
     *    .asIsPayload(Boolean | null) // nullable {@link IFTTTOutput#asIsPayload() asIsPayload}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.Output} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Output instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.IFTTTOutput} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IFTTTOutput instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Output) {
        Output instance = (Output) object;
        @Nullable String idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String collectionIDValue = instance.collectionID();
        if (collectionIDValue != null) {
          collectionID(collectionIDValue);
        }
        @Nullable Boolean enabledValue = instance.enabled();
        if (enabledValue != null) {
          enabled(enabledValue);
        }
        @Nullable Map<String, String> tagsValue = instance.tags();
        if (tagsValue != null) {
          putAllTags(tagsValue);
        }
      }
      if (object instanceof IFTTTOutput) {
        IFTTTOutput instance = (IFTTTOutput) object;
        eventName(instance.eventName());
        @Nullable Boolean asIsPayloadValue = instance.asIsPayload();
        if (asIsPayloadValue != null) {
          asIsPayload(asIsPayloadValue);
        }
        key(instance.key());
      }
    }

    /**
     * Initializes the value for the {@link IFTTTOutput#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link IFTTTOutput#collectionID() collectionID} attribute.
     * @param collectionID The value for collectionID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionID(@Nullable String collectionID) {
      this.collectionID = collectionID;
      return this;
    }

    /**
     * Initializes the value for the {@link IFTTTOutput#enabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Put one entry to the {@link IFTTTOutput#tags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(String key, String value) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link IFTTTOutput#tags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link IFTTTOutput#tags() tags} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tags = null;
        return this;
      }
      this.tags = new LinkedHashMap<String, String>();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link IFTTTOutput#tags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link IFTTTOutput#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link IFTTTOutput#eventName() eventName} attribute.
     * @param eventName The value for eventName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder eventName(String eventName) {
      this.eventName = Objects.requireNonNull(eventName, "eventName");
      initBits &= ~INIT_BIT_EVENT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link IFTTTOutput#asIsPayload() asIsPayload} attribute.
     * @param asIsPayload The value for asIsPayload (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder asIsPayload(@Nullable Boolean asIsPayload) {
      this.asIsPayload = asIsPayload;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIFTTTOutput ImmutableIFTTTOutput}.
     * @return An immutable instance of IFTTTOutput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIFTTTOutput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIFTTTOutput(
          id,
          collectionID,
          enabled,
          tags == null ? null : createUnmodifiableMap(false, false, tags),
          key,
          eventName,
          asIsPayload);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_EVENT_NAME) != 0) attributes.add("eventName");
      return "Cannot build IFTTTOutput, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
