package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Invite}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableInvite.Builder()}.
 */
@Generated(from = "Invite", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableInvite implements Invite {
  private final @Nullable String code;
  private final long createdAt;

  private ImmutableInvite(@Nullable String code, long createdAt) {
    this.code = code;
    this.createdAt = createdAt;
  }

  /**
   * The invite code.
   */
  @JsonProperty("code")
  @Override
  public @Nullable String code() {
    return code;
  }

  /**
   * The creation time, in milliseconds since Unix epoch.
   */
  @JsonProperty("createdAt")
  @Override
  public long createdAt() {
    return createdAt;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Invite#code() code} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInvite withCode(@Nullable String value) {
    if (Objects.equals(this.code, value)) return this;
    return new ImmutableInvite(value, this.createdAt);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Invite#createdAt() createdAt} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInvite withCreatedAt(long value) {
    if (this.createdAt == value) return this;
    return new ImmutableInvite(this.code, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInvite} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInvite
        && equalTo((ImmutableInvite) another);
  }

  private boolean equalTo(ImmutableInvite another) {
    return Objects.equals(code, another.code)
        && createdAt == another.createdAt;
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code createdAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(code);
    h += (h << 5) + Long.hashCode(createdAt);
    return h;
  }

  /**
   * Prints the immutable value {@code Invite} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Invite{"
        + "code=" + code
        + ", createdAt=" + createdAt
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Invite} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Invite instance
   */
  public static ImmutableInvite copyOf(Invite instance) {
    if (instance instanceof ImmutableInvite) {
      return (ImmutableInvite) instance;
    }
    return new ImmutableInvite.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableInvite ImmutableInvite}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Invite", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CREATED_AT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String code;
    private long createdAt;

    /**
     * Creates a builder for {@link ImmutableInvite ImmutableInvite} instances.
     * <pre>
     * new ImmutableInvite.Builder()
     *    .code(String | null) // nullable {@link Invite#code() code}
     *    .createdAt(long) // required {@link Invite#createdAt() createdAt}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Invite} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Invite instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String codeValue = instance.code();
      if (codeValue != null) {
        code(codeValue);
      }
      createdAt(instance.createdAt());
      return this;
    }

    /**
     * Initializes the value for the {@link Invite#code() code} attribute.
     * @param code The value for code (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("code")
    public final Builder code(@Nullable String code) {
      this.code = code;
      return this;
    }

    /**
     * Initializes the value for the {@link Invite#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("createdAt")
    public final Builder createdAt(long createdAt) {
      this.createdAt = createdAt;
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInvite ImmutableInvite}.
     * @return An immutable instance of Invite
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInvite build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInvite(code, createdAt);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      return "Cannot build Invite, some of required attributes are not set " + attributes;
    }
  }
}
