package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Invite.InviteList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableInviteList.Builder()}.
 */
@Generated(from = "Invite.InviteList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableInviteList implements Invite.InviteList {
  private final @Nullable Invite[] invites;

  private ImmutableInviteList(@Nullable Invite[] invites) {
    this.invites = invites;
  }

  /**
   * @return A cloned {@code invites} array
   */
  @JsonProperty("invites")
  @Override
  public @Nullable Invite[] invites() {
    return invites;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Invite.InviteList#invites() invites}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for invites
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInviteList withInvites(@Nullable Invite... elements) {
    @Nullable Invite[] newValue = elements == null ? null : elements.clone();
    return new ImmutableInviteList(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInviteList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInviteList
        && equalTo((ImmutableInviteList) another);
  }

  private boolean equalTo(ImmutableInviteList another) {
    return Arrays.equals(invites, another.invites);
  }

  /**
   * Computes a hash code from attributes: {@code invites}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(invites);
    return h;
  }

  /**
   * Prints the immutable value {@code InviteList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InviteList{"
        + "invites=" + Arrays.toString(invites)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Invite.InviteList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InviteList instance
   */
  public static ImmutableInviteList copyOf(Invite.InviteList instance) {
    if (instance instanceof ImmutableInviteList) {
      return (ImmutableInviteList) instance;
    }
    return new ImmutableInviteList.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableInviteList ImmutableInviteList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Invite.InviteList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Invite[] invites;

    /**
     * Creates a builder for {@link ImmutableInviteList ImmutableInviteList} instances.
     * <pre>
     * new ImmutableInviteList.Builder()
     *    .invites(com.telenordigital.nbiot.Invite[] | null) // nullable {@link Invite.InviteList#invites() invites}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InviteList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Invite.InviteList instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Invite[] invitesValue = instance.invites();
      if (invitesValue != null) {
        invites(invitesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Invite.InviteList#invites() invites} attribute.
     * @param invites The elements for invites
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("invites")
    public final Builder invites(Invite... invites) {
      this.invites = invites;
      return this;
    }

    /**
     * Builds a new {@link ImmutableInviteList ImmutableInviteList}.
     * @return An immutable instance of InviteList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInviteList build() {
      return new ImmutableInviteList(invites);
    }
  }
}
