package com.telenordigital.nbiot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MQTTOutput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableMQTTOutput.Builder()}.
 */
@Generated(from = "MQTTOutput", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMQTTOutput extends MQTTOutput {
  private final @Nullable String id;
  private final @Nullable String collectionID;
  private final @Nullable Boolean enabled;
  private final @Nullable Map<String, String> tags;
  private final String endpoint;
  private final @Nullable Boolean disableCertCheck;
  private final @Nullable String username;
  private final @Nullable String password;
  private final String clientID;
  private final String topicName;

  private ImmutableMQTTOutput(
      @Nullable String id,
      @Nullable String collectionID,
      @Nullable Boolean enabled,
      @Nullable Map<String, String> tags,
      String endpoint,
      @Nullable Boolean disableCertCheck,
      @Nullable String username,
      @Nullable String password,
      String clientID,
      String topicName) {
    this.id = id;
    this.collectionID = collectionID;
    this.enabled = enabled;
    this.tags = tags;
    this.endpoint = endpoint;
    this.disableCertCheck = disableCertCheck;
    this.username = username;
    this.password = password;
    this.clientID = clientID;
    this.topicName = topicName;
  }

  /**
   * The output's ID.
   */
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * The collection the output belongs to.
   */
  @Override
  public @Nullable String collectionID() {
    return collectionID;
  }

  /**
   * Whether the output is enabled.
   */
  @Override
  public @Nullable Boolean enabled() {
    return enabled;
  }

  /**
   * Output tags.
   */
  @Override
  public @Nullable Map<String, String> tags() {
    return tags;
  }

  /**
   * The output's endpoint.
   */
  @Override
  public String endpoint() {
    return endpoint;
  }

  /**
   * The output's disableCertCheck.
   */
  @Override
  public @Nullable Boolean disableCertCheck() {
    return disableCertCheck;
  }

  /**
   * The output's username.
   */
  @Override
  public @Nullable String username() {
    return username;
  }

  /**
   * The output's password.
   */
  @Override
  public @Nullable String password() {
    return password;
  }

  /**
   * The output's clientID.
   */
  @Override
  public String clientID() {
    return clientID;
  }

  /**
   * The output's topicName.
   */
  @Override
  public String topicName() {
    return topicName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableMQTTOutput(
        value,
        this.collectionID,
        this.enabled,
        this.tags,
        this.endpoint,
        this.disableCertCheck,
        this.username,
        this.password,
        this.clientID,
        this.topicName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#collectionID() collectionID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withCollectionID(@Nullable String value) {
    if (Objects.equals(this.collectionID, value)) return this;
    return new ImmutableMQTTOutput(
        this.id,
        value,
        this.enabled,
        this.tags,
        this.endpoint,
        this.disableCertCheck,
        this.username,
        this.password,
        this.clientID,
        this.topicName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#enabled() enabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withEnabled(@Nullable Boolean value) {
    if (Objects.equals(this.enabled, value)) return this;
    return new ImmutableMQTTOutput(
        this.id,
        this.collectionID,
        value,
        this.tags,
        this.endpoint,
        this.disableCertCheck,
        this.username,
        this.password,
        this.clientID,
        this.topicName);
  }

  /**
   * Copy the current immutable object by replacing the {@link MQTTOutput#tags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMQTTOutput withTags(@Nullable Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableMQTTOutput(
        this.id,
        this.collectionID,
        this.enabled,
        newValue,
        this.endpoint,
        this.disableCertCheck,
        this.username,
        this.password,
        this.clientID,
        this.topicName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#endpoint() endpoint} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for endpoint
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withEndpoint(String value) {
    String newValue = Objects.requireNonNull(value, "endpoint");
    if (this.endpoint.equals(newValue)) return this;
    return new ImmutableMQTTOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        newValue,
        this.disableCertCheck,
        this.username,
        this.password,
        this.clientID,
        this.topicName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#disableCertCheck() disableCertCheck} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disableCertCheck (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withDisableCertCheck(@Nullable Boolean value) {
    if (Objects.equals(this.disableCertCheck, value)) return this;
    return new ImmutableMQTTOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.endpoint,
        value,
        this.username,
        this.password,
        this.clientID,
        this.topicName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#username() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for username (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withUsername(@Nullable String value) {
    if (Objects.equals(this.username, value)) return this;
    return new ImmutableMQTTOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.endpoint,
        this.disableCertCheck,
        value,
        this.password,
        this.clientID,
        this.topicName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withPassword(@Nullable String value) {
    if (Objects.equals(this.password, value)) return this;
    return new ImmutableMQTTOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.endpoint,
        this.disableCertCheck,
        this.username,
        value,
        this.clientID,
        this.topicName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#clientID() clientID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientID
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withClientID(String value) {
    String newValue = Objects.requireNonNull(value, "clientID");
    if (this.clientID.equals(newValue)) return this;
    return new ImmutableMQTTOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.endpoint,
        this.disableCertCheck,
        this.username,
        this.password,
        newValue,
        this.topicName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MQTTOutput#topicName() topicName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for topicName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMQTTOutput withTopicName(String value) {
    String newValue = Objects.requireNonNull(value, "topicName");
    if (this.topicName.equals(newValue)) return this;
    return new ImmutableMQTTOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.endpoint,
        this.disableCertCheck,
        this.username,
        this.password,
        this.clientID,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMQTTOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMQTTOutput
        && equalTo((ImmutableMQTTOutput) another);
  }

  private boolean equalTo(ImmutableMQTTOutput another) {
    return Objects.equals(id, another.id)
        && Objects.equals(collectionID, another.collectionID)
        && Objects.equals(enabled, another.enabled)
        && Objects.equals(tags, another.tags)
        && endpoint.equals(another.endpoint)
        && Objects.equals(disableCertCheck, another.disableCertCheck)
        && Objects.equals(username, another.username)
        && Objects.equals(password, another.password)
        && clientID.equals(another.clientID)
        && topicName.equals(another.topicName);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code collectionID}, {@code enabled}, {@code tags}, {@code endpoint}, {@code disableCertCheck}, {@code username}, {@code password}, {@code clientID}, {@code topicName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(collectionID);
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + endpoint.hashCode();
    h += (h << 5) + Objects.hashCode(disableCertCheck);
    h += (h << 5) + Objects.hashCode(username);
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + clientID.hashCode();
    h += (h << 5) + topicName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MQTTOutput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MQTTOutput{"
        + "id=" + id
        + ", collectionID=" + collectionID
        + ", enabled=" + enabled
        + ", tags=" + tags
        + ", endpoint=" + endpoint
        + ", disableCertCheck=" + disableCertCheck
        + ", username=" + username
        + ", password=" + password
        + ", clientID=" + clientID
        + ", topicName=" + topicName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MQTTOutput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MQTTOutput instance
   */
  public static ImmutableMQTTOutput copyOf(MQTTOutput instance) {
    if (instance instanceof ImmutableMQTTOutput) {
      return (ImmutableMQTTOutput) instance;
    }
    return new ImmutableMQTTOutput.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableMQTTOutput ImmutableMQTTOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MQTTOutput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ENDPOINT = 0x1L;
    private static final long INIT_BIT_CLIENT_I_D = 0x2L;
    private static final long INIT_BIT_TOPIC_NAME = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String collectionID;
    private @Nullable Boolean enabled;
    private Map<String, String> tags = null;
    private @Nullable String endpoint;
    private @Nullable Boolean disableCertCheck;
    private @Nullable String username;
    private @Nullable String password;
    private @Nullable String clientID;
    private @Nullable String topicName;

    /**
     * Creates a builder for {@link ImmutableMQTTOutput ImmutableMQTTOutput} instances.
     * <pre>
     * new ImmutableMQTTOutput.Builder()
     *    .id(String | null) // nullable {@link MQTTOutput#id() id}
     *    .collectionID(String | null) // nullable {@link MQTTOutput#collectionID() collectionID}
     *    .enabled(Boolean | null) // nullable {@link MQTTOutput#enabled() enabled}
     *    .tags(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link MQTTOutput#tags() tags}
     *    .endpoint(String) // required {@link MQTTOutput#endpoint() endpoint}
     *    .disableCertCheck(Boolean | null) // nullable {@link MQTTOutput#disableCertCheck() disableCertCheck}
     *    .username(String | null) // nullable {@link MQTTOutput#username() username}
     *    .password(String | null) // nullable {@link MQTTOutput#password() password}
     *    .clientID(String) // required {@link MQTTOutput#clientID() clientID}
     *    .topicName(String) // required {@link MQTTOutput#topicName() topicName}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.MQTTOutput} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MQTTOutput instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.Output} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Output instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof MQTTOutput) {
        MQTTOutput instance = (MQTTOutput) object;
        topicName(instance.topicName());
        endpoint(instance.endpoint());
        @Nullable String passwordValue = instance.password();
        if (passwordValue != null) {
          password(passwordValue);
        }
        @Nullable Boolean disableCertCheckValue = instance.disableCertCheck();
        if (disableCertCheckValue != null) {
          disableCertCheck(disableCertCheckValue);
        }
        clientID(instance.clientID());
        @Nullable String usernameValue = instance.username();
        if (usernameValue != null) {
          username(usernameValue);
        }
      }
      if (object instanceof Output) {
        Output instance = (Output) object;
        @Nullable String idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String collectionIDValue = instance.collectionID();
        if (collectionIDValue != null) {
          collectionID(collectionIDValue);
        }
        @Nullable Boolean enabledValue = instance.enabled();
        if (enabledValue != null) {
          enabled(enabledValue);
        }
        @Nullable Map<String, String> tagsValue = instance.tags();
        if (tagsValue != null) {
          putAllTags(tagsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link MQTTOutput#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link MQTTOutput#collectionID() collectionID} attribute.
     * @param collectionID The value for collectionID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionID(@Nullable String collectionID) {
      this.collectionID = collectionID;
      return this;
    }

    /**
     * Initializes the value for the {@link MQTTOutput#enabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Put one entry to the {@link MQTTOutput#tags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(String key, String value) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link MQTTOutput#tags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MQTTOutput#tags() tags} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tags = null;
        return this;
      }
      this.tags = new LinkedHashMap<String, String>();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MQTTOutput#tags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MQTTOutput#endpoint() endpoint} attribute.
     * @param endpoint The value for endpoint 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder endpoint(String endpoint) {
      this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
      initBits &= ~INIT_BIT_ENDPOINT;
      return this;
    }

    /**
     * Initializes the value for the {@link MQTTOutput#disableCertCheck() disableCertCheck} attribute.
     * @param disableCertCheck The value for disableCertCheck (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disableCertCheck(@Nullable Boolean disableCertCheck) {
      this.disableCertCheck = disableCertCheck;
      return this;
    }

    /**
     * Initializes the value for the {@link MQTTOutput#username() username} attribute.
     * @param username The value for username (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Initializes the value for the {@link MQTTOutput#password() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(@Nullable String password) {
      this.password = password;
      return this;
    }

    /**
     * Initializes the value for the {@link MQTTOutput#clientID() clientID} attribute.
     * @param clientID The value for clientID 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientID(String clientID) {
      this.clientID = Objects.requireNonNull(clientID, "clientID");
      initBits &= ~INIT_BIT_CLIENT_I_D;
      return this;
    }

    /**
     * Initializes the value for the {@link MQTTOutput#topicName() topicName} attribute.
     * @param topicName The value for topicName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder topicName(String topicName) {
      this.topicName = Objects.requireNonNull(topicName, "topicName");
      initBits &= ~INIT_BIT_TOPIC_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMQTTOutput ImmutableMQTTOutput}.
     * @return An immutable instance of MQTTOutput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMQTTOutput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMQTTOutput(
          id,
          collectionID,
          enabled,
          tags == null ? null : createUnmodifiableMap(false, false, tags),
          endpoint,
          disableCertCheck,
          username,
          password,
          clientID,
          topicName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ENDPOINT) != 0) attributes.add("endpoint");
      if ((initBits & INIT_BIT_CLIENT_I_D) != 0) attributes.add("clientID");
      if ((initBits & INIT_BIT_TOPIC_NAME) != 0) attributes.add("topicName");
      return "Cannot build MQTTOutput, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
