package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Member}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableMember.Builder()}.
 */
@Generated(from = "Member", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMember implements Member {
  private final @Nullable String userID;
  private final @Nullable String role;
  private final @Nullable String name;
  private final @Nullable String email;
  private final @Nullable String phone;
  private final boolean verifiedEmail;
  private final boolean verifiedPhone;
  private final @Nullable String connectID;
  private final @Nullable String gitHubLogin;
  private final @Nullable String authType;
  private final @Nullable String avatarURL;

  private ImmutableMember(
      @Nullable String userID,
      @Nullable String role,
      @Nullable String name,
      @Nullable String email,
      @Nullable String phone,
      boolean verifiedEmail,
      boolean verifiedPhone,
      @Nullable String connectID,
      @Nullable String gitHubLogin,
      @Nullable String authType,
      @Nullable String avatarURL) {
    this.userID = userID;
    this.role = role;
    this.name = name;
    this.email = email;
    this.phone = phone;
    this.verifiedEmail = verifiedEmail;
    this.verifiedPhone = verifiedPhone;
    this.connectID = connectID;
    this.gitHubLogin = gitHubLogin;
    this.authType = authType;
    this.avatarURL = avatarURL;
  }

  /**
   * The user's ID
   */
  @JsonProperty("userId")
  @Override
  public @Nullable String userID() {
    return userID;
  }

  /**
   * The user's role
   */
  @JsonProperty("role")
  @Override
  public @Nullable String role() {
    return role;
  }

  /**
   * The user's name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   * The user's email
   */
  @JsonProperty("email")
  @Override
  public @Nullable String email() {
    return email;
  }

  /**
   * The user's phone
   */
  @JsonProperty("phone")
  @Override
  public @Nullable String phone() {
    return phone;
  }

  /**
   * The user's verifiedEmail
   */
  @JsonProperty("verifiedEmail")
  @Override
  public boolean verifiedEmail() {
    return verifiedEmail;
  }

  /**
   * The user's verifiedPhone
   */
  @JsonProperty("verifiedPhone")
  @Override
  public boolean verifiedPhone() {
    return verifiedPhone;
  }

  /**
   * The user's connectID
   */
  @JsonProperty("connectID")
  @Override
  public @Nullable String connectID() {
    return connectID;
  }

  /**
   * The user's gitHubLogin
   */
  @JsonProperty("gitHubLogin")
  @Override
  public @Nullable String gitHubLogin() {
    return gitHubLogin;
  }

  /**
   * The user's authType
   */
  @JsonProperty("authType")
  @Override
  public @Nullable String authType() {
    return authType;
  }

  /**
   * The user's avatarURL
   */
  @JsonProperty("avatarURL")
  @Override
  public @Nullable String avatarURL() {
    return avatarURL;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#userID() userID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withUserID(@Nullable String value) {
    if (Objects.equals(this.userID, value)) return this;
    return new ImmutableMember(
        value,
        this.role,
        this.name,
        this.email,
        this.phone,
        this.verifiedEmail,
        this.verifiedPhone,
        this.connectID,
        this.gitHubLogin,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#role() role} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for role (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withRole(@Nullable String value) {
    if (Objects.equals(this.role, value)) return this;
    return new ImmutableMember(
        this.userID,
        value,
        this.name,
        this.email,
        this.phone,
        this.verifiedEmail,
        this.verifiedPhone,
        this.connectID,
        this.gitHubLogin,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        value,
        this.email,
        this.phone,
        this.verifiedEmail,
        this.verifiedPhone,
        this.connectID,
        this.gitHubLogin,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#email() email} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for email (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withEmail(@Nullable String value) {
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        this.name,
        value,
        this.phone,
        this.verifiedEmail,
        this.verifiedPhone,
        this.connectID,
        this.gitHubLogin,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#phone() phone} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for phone (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withPhone(@Nullable String value) {
    if (Objects.equals(this.phone, value)) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        this.name,
        this.email,
        value,
        this.verifiedEmail,
        this.verifiedPhone,
        this.connectID,
        this.gitHubLogin,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#verifiedEmail() verifiedEmail} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verifiedEmail
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withVerifiedEmail(boolean value) {
    if (this.verifiedEmail == value) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        this.name,
        this.email,
        this.phone,
        value,
        this.verifiedPhone,
        this.connectID,
        this.gitHubLogin,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#verifiedPhone() verifiedPhone} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verifiedPhone
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withVerifiedPhone(boolean value) {
    if (this.verifiedPhone == value) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        this.name,
        this.email,
        this.phone,
        this.verifiedEmail,
        value,
        this.connectID,
        this.gitHubLogin,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#connectID() connectID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withConnectID(@Nullable String value) {
    if (Objects.equals(this.connectID, value)) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        this.name,
        this.email,
        this.phone,
        this.verifiedEmail,
        this.verifiedPhone,
        value,
        this.gitHubLogin,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#gitHubLogin() gitHubLogin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gitHubLogin (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withGitHubLogin(@Nullable String value) {
    if (Objects.equals(this.gitHubLogin, value)) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        this.name,
        this.email,
        this.phone,
        this.verifiedEmail,
        this.verifiedPhone,
        this.connectID,
        value,
        this.authType,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#authType() authType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for authType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withAuthType(@Nullable String value) {
    if (Objects.equals(this.authType, value)) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        this.name,
        this.email,
        this.phone,
        this.verifiedEmail,
        this.verifiedPhone,
        this.connectID,
        this.gitHubLogin,
        value,
        this.avatarURL);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#avatarURL() avatarURL} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for avatarURL (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withAvatarURL(@Nullable String value) {
    if (Objects.equals(this.avatarURL, value)) return this;
    return new ImmutableMember(
        this.userID,
        this.role,
        this.name,
        this.email,
        this.phone,
        this.verifiedEmail,
        this.verifiedPhone,
        this.connectID,
        this.gitHubLogin,
        this.authType,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMember} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMember
        && equalTo((ImmutableMember) another);
  }

  private boolean equalTo(ImmutableMember another) {
    return Objects.equals(userID, another.userID)
        && Objects.equals(role, another.role)
        && Objects.equals(name, another.name)
        && Objects.equals(email, another.email)
        && Objects.equals(phone, another.phone)
        && verifiedEmail == another.verifiedEmail
        && verifiedPhone == another.verifiedPhone
        && Objects.equals(connectID, another.connectID)
        && Objects.equals(gitHubLogin, another.gitHubLogin)
        && Objects.equals(authType, another.authType)
        && Objects.equals(avatarURL, another.avatarURL);
  }

  /**
   * Computes a hash code from attributes: {@code userID}, {@code role}, {@code name}, {@code email}, {@code phone}, {@code verifiedEmail}, {@code verifiedPhone}, {@code connectID}, {@code gitHubLogin}, {@code authType}, {@code avatarURL}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(userID);
    h += (h << 5) + Objects.hashCode(role);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + Objects.hashCode(phone);
    h += (h << 5) + Boolean.hashCode(verifiedEmail);
    h += (h << 5) + Boolean.hashCode(verifiedPhone);
    h += (h << 5) + Objects.hashCode(connectID);
    h += (h << 5) + Objects.hashCode(gitHubLogin);
    h += (h << 5) + Objects.hashCode(authType);
    h += (h << 5) + Objects.hashCode(avatarURL);
    return h;
  }

  /**
   * Prints the immutable value {@code Member} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Member{"
        + "userID=" + userID
        + ", role=" + role
        + ", name=" + name
        + ", email=" + email
        + ", phone=" + phone
        + ", verifiedEmail=" + verifiedEmail
        + ", verifiedPhone=" + verifiedPhone
        + ", connectID=" + connectID
        + ", gitHubLogin=" + gitHubLogin
        + ", authType=" + authType
        + ", avatarURL=" + avatarURL
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Member} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Member instance
   */
  public static ImmutableMember copyOf(Member instance) {
    if (instance instanceof ImmutableMember) {
      return (ImmutableMember) instance;
    }
    return new ImmutableMember.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableMember ImmutableMember}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Member", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VERIFIED_EMAIL = 0x1L;
    private static final long INIT_BIT_VERIFIED_PHONE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String userID;
    private @Nullable String role;
    private @Nullable String name;
    private @Nullable String email;
    private @Nullable String phone;
    private boolean verifiedEmail;
    private boolean verifiedPhone;
    private @Nullable String connectID;
    private @Nullable String gitHubLogin;
    private @Nullable String authType;
    private @Nullable String avatarURL;

    /**
     * Creates a builder for {@link ImmutableMember ImmutableMember} instances.
     * <pre>
     * new ImmutableMember.Builder()
     *    .userID(String | null) // nullable {@link Member#userID() userID}
     *    .role(String | null) // nullable {@link Member#role() role}
     *    .name(String | null) // nullable {@link Member#name() name}
     *    .email(String | null) // nullable {@link Member#email() email}
     *    .phone(String | null) // nullable {@link Member#phone() phone}
     *    .verifiedEmail(boolean) // required {@link Member#verifiedEmail() verifiedEmail}
     *    .verifiedPhone(boolean) // required {@link Member#verifiedPhone() verifiedPhone}
     *    .connectID(String | null) // nullable {@link Member#connectID() connectID}
     *    .gitHubLogin(String | null) // nullable {@link Member#gitHubLogin() gitHubLogin}
     *    .authType(String | null) // nullable {@link Member#authType() authType}
     *    .avatarURL(String | null) // nullable {@link Member#avatarURL() avatarURL}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Member} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Member instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String userIDValue = instance.userID();
      if (userIDValue != null) {
        userID(userIDValue);
      }
      @Nullable String roleValue = instance.role();
      if (roleValue != null) {
        role(roleValue);
      }
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String emailValue = instance.email();
      if (emailValue != null) {
        email(emailValue);
      }
      @Nullable String phoneValue = instance.phone();
      if (phoneValue != null) {
        phone(phoneValue);
      }
      verifiedEmail(instance.verifiedEmail());
      verifiedPhone(instance.verifiedPhone());
      @Nullable String connectIDValue = instance.connectID();
      if (connectIDValue != null) {
        connectID(connectIDValue);
      }
      @Nullable String gitHubLoginValue = instance.gitHubLogin();
      if (gitHubLoginValue != null) {
        gitHubLogin(gitHubLoginValue);
      }
      @Nullable String authTypeValue = instance.authType();
      if (authTypeValue != null) {
        authType(authTypeValue);
      }
      @Nullable String avatarURLValue = instance.avatarURL();
      if (avatarURLValue != null) {
        avatarURL(avatarURLValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Member#userID() userID} attribute.
     * @param userID The value for userID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userId")
    public final Builder userID(@Nullable String userID) {
      this.userID = userID;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#role() role} attribute.
     * @param role The value for role (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("role")
    public final Builder role(@Nullable String role) {
      this.role = role;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#email() email} attribute.
     * @param email The value for email (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("email")
    public final Builder email(@Nullable String email) {
      this.email = email;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#phone() phone} attribute.
     * @param phone The value for phone (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("phone")
    public final Builder phone(@Nullable String phone) {
      this.phone = phone;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#verifiedEmail() verifiedEmail} attribute.
     * @param verifiedEmail The value for verifiedEmail 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("verifiedEmail")
    public final Builder verifiedEmail(boolean verifiedEmail) {
      this.verifiedEmail = verifiedEmail;
      initBits &= ~INIT_BIT_VERIFIED_EMAIL;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#verifiedPhone() verifiedPhone} attribute.
     * @param verifiedPhone The value for verifiedPhone 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("verifiedPhone")
    public final Builder verifiedPhone(boolean verifiedPhone) {
      this.verifiedPhone = verifiedPhone;
      initBits &= ~INIT_BIT_VERIFIED_PHONE;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#connectID() connectID} attribute.
     * @param connectID The value for connectID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("connectID")
    public final Builder connectID(@Nullable String connectID) {
      this.connectID = connectID;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#gitHubLogin() gitHubLogin} attribute.
     * @param gitHubLogin The value for gitHubLogin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("gitHubLogin")
    public final Builder gitHubLogin(@Nullable String gitHubLogin) {
      this.gitHubLogin = gitHubLogin;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#authType() authType} attribute.
     * @param authType The value for authType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authType")
    public final Builder authType(@Nullable String authType) {
      this.authType = authType;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#avatarURL() avatarURL} attribute.
     * @param avatarURL The value for avatarURL (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("avatarURL")
    public final Builder avatarURL(@Nullable String avatarURL) {
      this.avatarURL = avatarURL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMember ImmutableMember}.
     * @return An immutable instance of Member
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMember build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMember(
          userID,
          role,
          name,
          email,
          phone,
          verifiedEmail,
          verifiedPhone,
          connectID,
          gitHubLogin,
          authType,
          avatarURL);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERIFIED_EMAIL) != 0) attributes.add("verifiedEmail");
      if ((initBits & INIT_BIT_VERIFIED_PHONE) != 0) attributes.add("verifiedPhone");
      return "Cannot build Member, some of required attributes are not set " + attributes;
    }
  }
}
