package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputDataMessage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputDataMessage.Builder()}.
 */
@Generated(from = "OutputDataMessage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOutputDataMessage implements OutputDataMessage {
  private final Device device;
  private final byte[] payload;
  private final Instant received;

  private ImmutableOutputDataMessage(Device device, byte[] payload, Instant received) {
    this.device = device;
    this.payload = payload;
    this.received = received;
  }

  /**
   * The sending device.
   */
  @JsonProperty("device")
  @Override
  public Device device() {
    return device;
  }

  /**
   * The payload sent.
   */
  @JsonProperty("payload")
  @Override
  public byte[] payload() {
    return payload.clone();
  }

  /**
   * The time received.
   */
  @JsonProperty("received")
  @Override
  public Instant received() {
    return received;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputDataMessage#device() device} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for device
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputDataMessage withDevice(Device value) {
    if (this.device == value) return this;
    Device newValue = Objects.requireNonNull(value, "device");
    return new ImmutableOutputDataMessage(newValue, this.payload, this.received);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OutputDataMessage#payload() payload}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for payload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutputDataMessage withPayload(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutableOutputDataMessage(this.device, newValue, this.received);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputDataMessage#received() received} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for received
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputDataMessage withReceived(Instant value) {
    if (this.received == value) return this;
    Instant newValue = Objects.requireNonNull(value, "received");
    return new ImmutableOutputDataMessage(this.device, this.payload, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputDataMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputDataMessage
        && equalTo((ImmutableOutputDataMessage) another);
  }

  private boolean equalTo(ImmutableOutputDataMessage another) {
    return device.equals(another.device)
        && Arrays.equals(payload, another.payload)
        && received.equals(another.received);
  }

  /**
   * Computes a hash code from attributes: {@code device}, {@code payload}, {@code received}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + device.hashCode();
    h += (h << 5) + Arrays.hashCode(payload);
    h += (h << 5) + received.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OutputDataMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputDataMessage{"
        + "device=" + device
        + ", payload=" + Arrays.toString(payload)
        + ", received=" + received
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputDataMessage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputDataMessage instance
   */
  public static ImmutableOutputDataMessage copyOf(OutputDataMessage instance) {
    if (instance instanceof ImmutableOutputDataMessage) {
      return (ImmutableOutputDataMessage) instance;
    }
    return new ImmutableOutputDataMessage.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputDataMessage ImmutableOutputDataMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputDataMessage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEVICE = 0x1L;
    private static final long INIT_BIT_PAYLOAD = 0x2L;
    private static final long INIT_BIT_RECEIVED = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Device device;
    private @Nullable byte[] payload;
    private @Nullable Instant received;

    /**
     * Creates a builder for {@link ImmutableOutputDataMessage ImmutableOutputDataMessage} instances.
     * <pre>
     * new ImmutableOutputDataMessage.Builder()
     *    .device(com.telenordigital.nbiot.Device) // required {@link OutputDataMessage#device() device}
     *    .payload(byte) // required {@link OutputDataMessage#payload() payload}
     *    .received(java.time.Instant) // required {@link OutputDataMessage#received() received}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OutputDataMessage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputDataMessage instance) {
      Objects.requireNonNull(instance, "instance");
      device(instance.device());
      payload(instance.payload());
      received(instance.received());
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessage#device() device} attribute.
     * @param device The value for device 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("device")
    public final Builder device(Device device) {
      this.device = Objects.requireNonNull(device, "device");
      initBits &= ~INIT_BIT_DEVICE;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessage#payload() payload} attribute.
     * @param payload The elements for payload
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("payload")
    public final Builder payload(byte... payload) {
      this.payload = payload.clone();
      initBits &= ~INIT_BIT_PAYLOAD;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessage#received() received} attribute.
     * @param received The value for received 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("received")
    public final Builder received(Instant received) {
      this.received = Objects.requireNonNull(received, "received");
      initBits &= ~INIT_BIT_RECEIVED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputDataMessage ImmutableOutputDataMessage}.
     * @return An immutable instance of OutputDataMessage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputDataMessage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOutputDataMessage(device, payload, received);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEVICE) != 0) attributes.add("device");
      if ((initBits & INIT_BIT_PAYLOAD) != 0) attributes.add("payload");
      if ((initBits & INIT_BIT_RECEIVED) != 0) attributes.add("received");
      return "Cannot build OutputDataMessage, some of required attributes are not set " + attributes;
    }
  }
}
