package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputDataMessageInternal.OutputDataMessageListInternal}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputDataMessageListInternal.Builder()}.
 */
@Generated(from = "OutputDataMessageInternal.OutputDataMessageListInternal", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOutputDataMessageListInternal
    implements OutputDataMessageInternal.OutputDataMessageListInternal {
  private final OutputDataMessageInternal[] messages;

  private ImmutableOutputDataMessageListInternal(OutputDataMessageInternal[] messages) {
    this.messages = messages;
  }

  /**
   * @return A cloned {@code messages} array
   */
  @JsonProperty("messages")
  @Override
  public OutputDataMessageInternal[] messages() {
    return messages.clone();
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OutputDataMessageInternal.OutputDataMessageListInternal#messages() messages}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for messages
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutputDataMessageListInternal withMessages(OutputDataMessageInternal... elements) {
    OutputDataMessageInternal[] newValue = elements.clone();
    return new ImmutableOutputDataMessageListInternal(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputDataMessageListInternal} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputDataMessageListInternal
        && equalTo((ImmutableOutputDataMessageListInternal) another);
  }

  private boolean equalTo(ImmutableOutputDataMessageListInternal another) {
    return Arrays.equals(messages, another.messages);
  }

  /**
   * Computes a hash code from attributes: {@code messages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(messages);
    return h;
  }

  /**
   * Prints the immutable value {@code OutputDataMessageListInternal} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputDataMessageListInternal{"
        + "messages=" + Arrays.toString(messages)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputDataMessageInternal.OutputDataMessageListInternal} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputDataMessageListInternal instance
   */
  public static ImmutableOutputDataMessageListInternal copyOf(OutputDataMessageInternal.OutputDataMessageListInternal instance) {
    if (instance instanceof ImmutableOutputDataMessageListInternal) {
      return (ImmutableOutputDataMessageListInternal) instance;
    }
    return new ImmutableOutputDataMessageListInternal.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputDataMessageListInternal ImmutableOutputDataMessageListInternal}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputDataMessageInternal.OutputDataMessageListInternal", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MESSAGES = 0x1L;
    private long initBits = 0x1L;

    private @Nullable OutputDataMessageInternal[] messages;

    /**
     * Creates a builder for {@link ImmutableOutputDataMessageListInternal ImmutableOutputDataMessageListInternal} instances.
     * <pre>
     * new ImmutableOutputDataMessageListInternal.Builder()
     *    .messages(com.telenordigital.nbiot.OutputDataMessageInternal) // required {@link OutputDataMessageInternal.OutputDataMessageListInternal#messages() messages}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OutputDataMessageListInternal} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputDataMessageInternal.OutputDataMessageListInternal instance) {
      Objects.requireNonNull(instance, "instance");
      messages(instance.messages());
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessageInternal.OutputDataMessageListInternal#messages() messages} attribute.
     * @param messages The elements for messages
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("messages")
    public final Builder messages(OutputDataMessageInternal... messages) {
      this.messages = messages.clone();
      initBits &= ~INIT_BIT_MESSAGES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputDataMessageListInternal ImmutableOutputDataMessageListInternal}.
     * @return An immutable instance of OutputDataMessageListInternal
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputDataMessageListInternal build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOutputDataMessageListInternal(messages);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MESSAGES) != 0) attributes.add("messages");
      return "Cannot build OutputDataMessageListInternal, some of required attributes are not set " + attributes;
    }
  }
}
