package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputInternal}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputInternal.Builder()}.
 */
@Generated(from = "OutputInternal", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableOutputInternal extends OutputInternal {
  private final @Nullable OutputInternal toInternal;
  private final @Nullable String id;
  private final @Nullable String collectionID;
  private final @Nullable String type;
  private final @Nullable Map<String, Object> config;
  private final @Nullable Boolean enabled;
  private final @Nullable Map<String, String> tags;

  private ImmutableOutputInternal(
      @Nullable OutputInternal toInternal,
      @Nullable String id,
      @Nullable String collectionID,
      @Nullable String type,
      @Nullable Map<String, Object> config,
      @Nullable Boolean enabled,
      @Nullable Map<String, String> tags) {
    this.toInternal = toInternal;
    this.id = id;
    this.collectionID = collectionID;
    this.type = type;
    this.config = config;
    this.enabled = enabled;
    this.tags = tags;
  }

  /**
   * @return The value of the {@code toInternal} attribute
   */
  @JsonProperty("toInternal")
  @Override
  public @Nullable OutputInternal toInternal() {
    return toInternal;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("outputId")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * @return The value of the {@code collectionID} attribute
   */
  @JsonProperty("collectionId")
  @Override
  public @Nullable String collectionID() {
    return collectionID;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public @Nullable Map<String, Object> config() {
    return config;
  }

  /**
   * @return The value of the {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public @Nullable Boolean enabled() {
    return enabled;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public @Nullable Map<String, String> tags() {
    return tags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputInternal#toInternal() toInternal} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toInternal (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputInternal withToInternal(@Nullable OutputInternal value) {
    if (this.toInternal == value) return this;
    return new ImmutableOutputInternal(value, this.id, this.collectionID, this.type, this.config, this.enabled, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputInternal#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputInternal withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableOutputInternal(this.toInternal, value, this.collectionID, this.type, this.config, this.enabled, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputInternal#collectionID() collectionID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputInternal withCollectionID(@Nullable String value) {
    if (Objects.equals(this.collectionID, value)) return this;
    return new ImmutableOutputInternal(this.toInternal, this.id, value, this.type, this.config, this.enabled, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputInternal#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputInternal withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableOutputInternal(this.toInternal, this.id, this.collectionID, value, this.config, this.enabled, this.tags);
  }

  /**
   * Copy the current immutable object by replacing the {@link OutputInternal#config() config} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the config map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutputInternal withConfig(@Nullable Map<String, ? extends Object> entries) {
    if (this.config == entries) return this;
    @Nullable Map<String, Object> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableOutputInternal(this.toInternal, this.id, this.collectionID, this.type, newValue, this.enabled, this.tags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputInternal#enabled() enabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputInternal withEnabled(@Nullable Boolean value) {
    if (Objects.equals(this.enabled, value)) return this;
    return new ImmutableOutputInternal(this.toInternal, this.id, this.collectionID, this.type, this.config, value, this.tags);
  }

  /**
   * Copy the current immutable object by replacing the {@link OutputInternal#tags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutputInternal withTags(@Nullable Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableOutputInternal(this.toInternal, this.id, this.collectionID, this.type, this.config, this.enabled, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputInternal} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputInternal
        && equalTo((ImmutableOutputInternal) another);
  }

  private boolean equalTo(ImmutableOutputInternal another) {
    return Objects.equals(toInternal, another.toInternal)
        && Objects.equals(id, another.id)
        && Objects.equals(collectionID, another.collectionID)
        && Objects.equals(type, another.type)
        && Objects.equals(config, another.config)
        && Objects.equals(enabled, another.enabled)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code toInternal}, {@code id}, {@code collectionID}, {@code type}, {@code config}, {@code enabled}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(toInternal);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(collectionID);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(config);
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code OutputInternal} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputInternal{"
        + "toInternal=" + toInternal
        + ", id=" + id
        + ", collectionID=" + collectionID
        + ", type=" + type
        + ", config=" + config
        + ", enabled=" + enabled
        + ", tags=" + tags
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputInternal} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputInternal instance
   */
  public static ImmutableOutputInternal copyOf(OutputInternal instance) {
    if (instance instanceof ImmutableOutputInternal) {
      return (ImmutableOutputInternal) instance;
    }
    return new ImmutableOutputInternal.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputInternal ImmutableOutputInternal}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputInternal", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable OutputInternal toInternal;
    private @Nullable String id;
    private @Nullable String collectionID;
    private @Nullable String type;
    private Map<String, Object> config = null;
    private @Nullable Boolean enabled;
    private Map<String, String> tags = null;

    /**
     * Creates a builder for {@link ImmutableOutputInternal ImmutableOutputInternal} instances.
     * <pre>
     * new ImmutableOutputInternal.Builder()
     *    .toInternal(com.telenordigital.nbiot.OutputInternal | null) // nullable {@link OutputInternal#toInternal() toInternal}
     *    .id(String | null) // nullable {@link OutputInternal#id() id}
     *    .collectionID(String | null) // nullable {@link OutputInternal#collectionID() collectionID}
     *    .type(String | null) // nullable {@link OutputInternal#type() type}
     *    .config(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link OutputInternal#config() config}
     *    .enabled(Boolean | null) // nullable {@link OutputInternal#enabled() enabled}
     *    .tags(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link OutputInternal#tags() tags}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.Output} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Output instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.OutputInternal} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputInternal instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof Output) {
        Output instance = (Output) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String idValue = instance.id();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x1L;
        }
        @Nullable OutputInternal toInternalValue = instance.toInternal();
        if (toInternalValue != null) {
          toInternal(toInternalValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable String collectionIDValue = instance.collectionID();
          if (collectionIDValue != null) {
            collectionID(collectionIDValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable Boolean enabledValue = instance.enabled();
          if (enabledValue != null) {
            enabled(enabledValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Map<String, String> tagsValue = instance.tags();
          if (tagsValue != null) {
            putAllTags(tagsValue);
          }
          bits |= 0x8L;
        }
      }
      if (object instanceof OutputInternal) {
        OutputInternal instance = (OutputInternal) object;
        if ((bits & 0x1L) == 0) {
          @Nullable String idValue = instance.id();
          if (idValue != null) {
            id(idValue);
          }
          bits |= 0x1L;
        }
        @Nullable String typeValue = instance.type();
        if (typeValue != null) {
          type(typeValue);
        }
        if ((bits & 0x2L) == 0) {
          @Nullable String collectionIDValue = instance.collectionID();
          if (collectionIDValue != null) {
            collectionID(collectionIDValue);
          }
          bits |= 0x2L;
        }
        @Nullable Map<String, Object> configValue = instance.config();
        if (configValue != null) {
          putAllConfig(configValue);
        }
        if ((bits & 0x4L) == 0) {
          @Nullable Boolean enabledValue = instance.enabled();
          if (enabledValue != null) {
            enabled(enabledValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable Map<String, String> tagsValue = instance.tags();
          if (tagsValue != null) {
            putAllTags(tagsValue);
          }
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the value for the {@link OutputInternal#toInternal() toInternal} attribute.
     * @param toInternal The value for toInternal (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("toInternal")
    public final Builder toInternal(@Nullable OutputInternal toInternal) {
      this.toInternal = toInternal;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputInternal#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("outputId")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputInternal#collectionID() collectionID} attribute.
     * @param collectionID The value for collectionID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("collectionId")
    public final Builder collectionID(@Nullable String collectionID) {
      this.collectionID = collectionID;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputInternal#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link OutputInternal#config() config} map.
     * @param key The key in the config map
     * @param value The associated value in the config map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putConfig(String key, Object value) {
      if (this.config == null) {
        this.config = new LinkedHashMap<String, Object>();
      }
      this.config.put(
          Objects.requireNonNull(key, "config key"),
          Objects.requireNonNull(value, "config value"));
      return this;
    }

    /**
     * Put one entry to the {@link OutputInternal#config() config} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putConfig(Map.Entry<String, ? extends Object> entry) {
      if (this.config == null) {
        this.config = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.config.put(
          Objects.requireNonNull(k, "config key"),
          Objects.requireNonNull(v, "config value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OutputInternal#config() config} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the config map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("config")
    public final Builder config(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.config = null;
        return this;
      }
      this.config = new LinkedHashMap<String, Object>();
      return putAllConfig(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OutputInternal#config() config} map. Nulls are not permitted
     * @param entries The entries that will be added to the config map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllConfig(Map<String, ? extends Object> entries) {
      if (this.config == null) {
        this.config = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.config.put(
            Objects.requireNonNull(k, "config key"),
            Objects.requireNonNull(v, "config value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OutputInternal#enabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("enabled")
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Put one entry to the {@link OutputInternal#tags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(String key, String value) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link OutputInternal#tags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OutputInternal#tags() tags} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tags = null;
        return this;
      }
      this.tags = new LinkedHashMap<String, String>();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OutputInternal#tags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputInternal ImmutableOutputInternal}.
     * @return An immutable instance of OutputInternal
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputInternal build() {
      return new ImmutableOutputInternal(
          toInternal,
          id,
          collectionID,
          type,
          config == null ? null : createUnmodifiableMap(false, false, config),
          enabled,
          tags == null ? null : createUnmodifiableMap(false, false, tags));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
