package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputInternal.OutputList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputList.Builder()}.
 */
@Generated(from = "OutputInternal.OutputList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableOutputList implements OutputInternal.OutputList {
  private final @Nullable OutputInternal[] outputs;

  private ImmutableOutputList(@Nullable OutputInternal[] outputs) {
    this.outputs = outputs;
  }

  /**
   * @return A cloned {@code outputs} array
   */
  @JsonProperty("outputs")
  @Override
  public @Nullable OutputInternal[] outputs() {
    return outputs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OutputInternal.OutputList#outputs() outputs}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for outputs
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutputList withOutputs(@Nullable OutputInternal... elements) {
    @Nullable OutputInternal[] newValue = elements == null ? null : elements.clone();
    return new ImmutableOutputList(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputList
        && equalTo((ImmutableOutputList) another);
  }

  private boolean equalTo(ImmutableOutputList another) {
    return Arrays.equals(outputs, another.outputs);
  }

  /**
   * Computes a hash code from attributes: {@code outputs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(outputs);
    return h;
  }

  /**
   * Prints the immutable value {@code OutputList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputList{"
        + "outputs=" + Arrays.toString(outputs)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputInternal.OutputList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputList instance
   */
  public static ImmutableOutputList copyOf(OutputInternal.OutputList instance) {
    if (instance instanceof ImmutableOutputList) {
      return (ImmutableOutputList) instance;
    }
    return new ImmutableOutputList.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputList ImmutableOutputList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputInternal.OutputList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable OutputInternal[] outputs;

    /**
     * Creates a builder for {@link ImmutableOutputList ImmutableOutputList} instances.
     * <pre>
     * new ImmutableOutputList.Builder()
     *    .outputs(com.telenordigital.nbiot.OutputInternal[] | null) // nullable {@link OutputInternal.OutputList#outputs() outputs}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OutputList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputInternal.OutputList instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable OutputInternal[] outputsValue = instance.outputs();
      if (outputsValue != null) {
        outputs(outputsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OutputInternal.OutputList#outputs() outputs} attribute.
     * @param outputs The elements for outputs
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("outputs")
    public final Builder outputs(OutputInternal... outputs) {
      this.outputs = outputs;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputList ImmutableOutputList}.
     * @return An immutable instance of OutputList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputList build() {
      return new ImmutableOutputList(outputs);
    }
  }
}
