package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputLogEntry.OutputLog}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputLog.Builder()}.
 */
@Generated(from = "OutputLogEntry.OutputLog", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOutputLog implements OutputLogEntry.OutputLog {
  private final @Nullable OutputLogEntry[] logs;

  private ImmutableOutputLog(@Nullable OutputLogEntry[] logs) {
    this.logs = logs;
  }

  /**
   * @return A cloned {@code logs} array
   */
  @JsonProperty("logs")
  @Override
  public @Nullable OutputLogEntry[] logs() {
    return logs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OutputLogEntry.OutputLog#logs() logs}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for logs
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutputLog withLogs(@Nullable OutputLogEntry... elements) {
    @Nullable OutputLogEntry[] newValue = elements == null ? null : elements.clone();
    return new ImmutableOutputLog(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputLog} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputLog
        && equalTo((ImmutableOutputLog) another);
  }

  private boolean equalTo(ImmutableOutputLog another) {
    return Arrays.equals(logs, another.logs);
  }

  /**
   * Computes a hash code from attributes: {@code logs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(logs);
    return h;
  }

  /**
   * Prints the immutable value {@code OutputLog} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputLog{"
        + "logs=" + Arrays.toString(logs)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputLogEntry.OutputLog} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputLog instance
   */
  public static ImmutableOutputLog copyOf(OutputLogEntry.OutputLog instance) {
    if (instance instanceof ImmutableOutputLog) {
      return (ImmutableOutputLog) instance;
    }
    return new ImmutableOutputLog.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputLog ImmutableOutputLog}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputLogEntry.OutputLog", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable OutputLogEntry[] logs;

    /**
     * Creates a builder for {@link ImmutableOutputLog ImmutableOutputLog} instances.
     * <pre>
     * new ImmutableOutputLog.Builder()
     *    .logs(com.telenordigital.nbiot.OutputLogEntry[] | null) // nullable {@link OutputLogEntry.OutputLog#logs() logs}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OutputLog} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputLogEntry.OutputLog instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable OutputLogEntry[] logsValue = instance.logs();
      if (logsValue != null) {
        logs(logsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OutputLogEntry.OutputLog#logs() logs} attribute.
     * @param logs The elements for logs
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("logs")
    public final Builder logs(OutputLogEntry... logs) {
      this.logs = logs;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputLog ImmutableOutputLog}.
     * @return An immutable instance of OutputLog
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputLog build() {
      return new ImmutableOutputLog(logs);
    }
  }
}
