package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputLogEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputLogEntry.Builder()}.
 */
@Generated(from = "OutputLogEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOutputLogEntry implements OutputLogEntry {
  private final String message;
  private final long timestamp;
  private final int repeated;

  private ImmutableOutputLogEntry(String message, long timestamp, int repeated) {
    this.message = message;
    this.timestamp = timestamp;
    this.repeated = repeated;
  }

  /**
   * The log message.
   */
  @JsonProperty("message")
  @Override
  public String message() {
    return message;
  }

  /**
   * The time the entry was received, in milliseconds since Unix epoch.
   */
  @JsonProperty("timestamp")
  @Override
  public long timestamp() {
    return timestamp;
  }

  /**
   * The number of times the entry was repeated.
   */
  @JsonProperty("repeated")
  @Override
  public int repeated() {
    return repeated;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputLogEntry#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputLogEntry withMessage(String value) {
    String newValue = Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableOutputLogEntry(newValue, this.timestamp, this.repeated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputLogEntry#timestamp() timestamp} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputLogEntry withTimestamp(long value) {
    if (this.timestamp == value) return this;
    return new ImmutableOutputLogEntry(this.message, value, this.repeated);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputLogEntry#repeated() repeated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repeated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputLogEntry withRepeated(int value) {
    if (this.repeated == value) return this;
    return new ImmutableOutputLogEntry(this.message, this.timestamp, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputLogEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputLogEntry
        && equalTo((ImmutableOutputLogEntry) another);
  }

  private boolean equalTo(ImmutableOutputLogEntry another) {
    return message.equals(another.message)
        && timestamp == another.timestamp
        && repeated == another.repeated;
  }

  /**
   * Computes a hash code from attributes: {@code message}, {@code timestamp}, {@code repeated}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + message.hashCode();
    h += (h << 5) + Long.hashCode(timestamp);
    h += (h << 5) + repeated;
    return h;
  }

  /**
   * Prints the immutable value {@code OutputLogEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputLogEntry{"
        + "message=" + message
        + ", timestamp=" + timestamp
        + ", repeated=" + repeated
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputLogEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputLogEntry instance
   */
  public static ImmutableOutputLogEntry copyOf(OutputLogEntry instance) {
    if (instance instanceof ImmutableOutputLogEntry) {
      return (ImmutableOutputLogEntry) instance;
    }
    return new ImmutableOutputLogEntry.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputLogEntry ImmutableOutputLogEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputLogEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MESSAGE = 0x1L;
    private static final long INIT_BIT_TIMESTAMP = 0x2L;
    private static final long INIT_BIT_REPEATED = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String message;
    private long timestamp;
    private int repeated;

    /**
     * Creates a builder for {@link ImmutableOutputLogEntry ImmutableOutputLogEntry} instances.
     * <pre>
     * new ImmutableOutputLogEntry.Builder()
     *    .message(String) // required {@link OutputLogEntry#message() message}
     *    .timestamp(long) // required {@link OutputLogEntry#timestamp() timestamp}
     *    .repeated(int) // required {@link OutputLogEntry#repeated() repeated}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OutputLogEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputLogEntry instance) {
      Objects.requireNonNull(instance, "instance");
      message(instance.message());
      timestamp(instance.timestamp());
      repeated(instance.repeated());
      return this;
    }

    /**
     * Initializes the value for the {@link OutputLogEntry#message() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputLogEntry#timestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timestamp")
    public final Builder timestamp(long timestamp) {
      this.timestamp = timestamp;
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputLogEntry#repeated() repeated} attribute.
     * @param repeated The value for repeated 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("repeated")
    public final Builder repeated(int repeated) {
      this.repeated = repeated;
      initBits &= ~INIT_BIT_REPEATED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputLogEntry ImmutableOutputLogEntry}.
     * @return An immutable instance of OutputLogEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputLogEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOutputLogEntry(message, timestamp, repeated);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      if ((initBits & INIT_BIT_REPEATED) != 0) attributes.add("repeated");
      return "Cannot build OutputLogEntry, some of required attributes are not set " + attributes;
    }
  }
}
