package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputStatus}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputStatus.Builder()}.
 */
@Generated(from = "OutputStatus", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOutputStatus implements OutputStatus {
  private final int errorCount;
  private final int forwarded;
  private final int received;
  private final int retries;

  private ImmutableOutputStatus(int errorCount, int forwarded, int received, int retries) {
    this.errorCount = errorCount;
    this.forwarded = forwarded;
    this.received = received;
    this.retries = retries;
  }

  /**
   * The number of errors.
   */
  @JsonProperty("errorCount")
  @Override
  public int errorCount() {
    return errorCount;
  }

  /**
   * The number of messages forwarded.
   */
  @JsonProperty("forwarded")
  @Override
  public int forwarded() {
    return forwarded;
  }

  /**
   * The number of messages received.
   */
  @JsonProperty("received")
  @Override
  public int received() {
    return received;
  }

  /**
   * The number of messages retransmitted.
   */
  @JsonProperty("retries")
  @Override
  public int retries() {
    return retries;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputStatus#errorCount() errorCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputStatus withErrorCount(int value) {
    if (this.errorCount == value) return this;
    return new ImmutableOutputStatus(value, this.forwarded, this.received, this.retries);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputStatus#forwarded() forwarded} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forwarded
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputStatus withForwarded(int value) {
    if (this.forwarded == value) return this;
    return new ImmutableOutputStatus(this.errorCount, value, this.received, this.retries);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputStatus#received() received} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for received
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputStatus withReceived(int value) {
    if (this.received == value) return this;
    return new ImmutableOutputStatus(this.errorCount, this.forwarded, value, this.retries);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputStatus#retries() retries} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for retries
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputStatus withRetries(int value) {
    if (this.retries == value) return this;
    return new ImmutableOutputStatus(this.errorCount, this.forwarded, this.received, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputStatus} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputStatus
        && equalTo((ImmutableOutputStatus) another);
  }

  private boolean equalTo(ImmutableOutputStatus another) {
    return errorCount == another.errorCount
        && forwarded == another.forwarded
        && received == another.received
        && retries == another.retries;
  }

  /**
   * Computes a hash code from attributes: {@code errorCount}, {@code forwarded}, {@code received}, {@code retries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + errorCount;
    h += (h << 5) + forwarded;
    h += (h << 5) + received;
    h += (h << 5) + retries;
    return h;
  }

  /**
   * Prints the immutable value {@code OutputStatus} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputStatus{"
        + "errorCount=" + errorCount
        + ", forwarded=" + forwarded
        + ", received=" + received
        + ", retries=" + retries
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputStatus} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputStatus instance
   */
  public static ImmutableOutputStatus copyOf(OutputStatus instance) {
    if (instance instanceof ImmutableOutputStatus) {
      return (ImmutableOutputStatus) instance;
    }
    return new ImmutableOutputStatus.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputStatus ImmutableOutputStatus}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputStatus", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ERROR_COUNT = 0x1L;
    private static final long INIT_BIT_FORWARDED = 0x2L;
    private static final long INIT_BIT_RECEIVED = 0x4L;
    private static final long INIT_BIT_RETRIES = 0x8L;
    private long initBits = 0xfL;

    private int errorCount;
    private int forwarded;
    private int received;
    private int retries;

    /**
     * Creates a builder for {@link ImmutableOutputStatus ImmutableOutputStatus} instances.
     * <pre>
     * new ImmutableOutputStatus.Builder()
     *    .errorCount(int) // required {@link OutputStatus#errorCount() errorCount}
     *    .forwarded(int) // required {@link OutputStatus#forwarded() forwarded}
     *    .received(int) // required {@link OutputStatus#received() received}
     *    .retries(int) // required {@link OutputStatus#retries() retries}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OutputStatus} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputStatus instance) {
      Objects.requireNonNull(instance, "instance");
      errorCount(instance.errorCount());
      forwarded(instance.forwarded());
      received(instance.received());
      retries(instance.retries());
      return this;
    }

    /**
     * Initializes the value for the {@link OutputStatus#errorCount() errorCount} attribute.
     * @param errorCount The value for errorCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errorCount")
    public final Builder errorCount(int errorCount) {
      this.errorCount = errorCount;
      initBits &= ~INIT_BIT_ERROR_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputStatus#forwarded() forwarded} attribute.
     * @param forwarded The value for forwarded 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("forwarded")
    public final Builder forwarded(int forwarded) {
      this.forwarded = forwarded;
      initBits &= ~INIT_BIT_FORWARDED;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputStatus#received() received} attribute.
     * @param received The value for received 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("received")
    public final Builder received(int received) {
      this.received = received;
      initBits &= ~INIT_BIT_RECEIVED;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputStatus#retries() retries} attribute.
     * @param retries The value for retries 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("retries")
    public final Builder retries(int retries) {
      this.retries = retries;
      initBits &= ~INIT_BIT_RETRIES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputStatus ImmutableOutputStatus}.
     * @return An immutable instance of OutputStatus
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputStatus build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOutputStatus(errorCount, forwarded, received, retries);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ERROR_COUNT) != 0) attributes.add("errorCount");
      if ((initBits & INIT_BIT_FORWARDED) != 0) attributes.add("forwarded");
      if ((initBits & INIT_BIT_RECEIVED) != 0) attributes.add("received");
      if ((initBits & INIT_BIT_RETRIES) != 0) attributes.add("retries");
      return "Cannot build OutputStatus, some of required attributes are not set " + attributes;
    }
  }
}
