package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SystemDefaults}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableSystemDefaults.Builder()}.
 */
@Generated(from = "SystemDefaults", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSystemDefaults implements SystemDefaults {
  private final @Nullable FieldMask fieldMask;
  private final @Nullable FieldMask forcedFieldMask;

  private ImmutableSystemDefaults(
      @Nullable FieldMask fieldMask,
      @Nullable FieldMask forcedFieldMask) {
    this.fieldMask = fieldMask;
    this.forcedFieldMask = forcedFieldMask;
  }

  /**
   * The default field mask
   */
  @JsonProperty("defaultFieldMask")
  @Override
  public @Nullable FieldMask fieldMask() {
    return fieldMask;
  }

  /**
   * The forced field mask
   */
  @JsonProperty("forcedFieldMask")
  @Override
  public @Nullable FieldMask forcedFieldMask() {
    return forcedFieldMask;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SystemDefaults#fieldMask() fieldMask} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldMask (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSystemDefaults withFieldMask(@Nullable FieldMask value) {
    if (this.fieldMask == value) return this;
    return new ImmutableSystemDefaults(value, this.forcedFieldMask);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SystemDefaults#forcedFieldMask() forcedFieldMask} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forcedFieldMask (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSystemDefaults withForcedFieldMask(@Nullable FieldMask value) {
    if (this.forcedFieldMask == value) return this;
    return new ImmutableSystemDefaults(this.fieldMask, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSystemDefaults} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSystemDefaults
        && equalTo((ImmutableSystemDefaults) another);
  }

  private boolean equalTo(ImmutableSystemDefaults another) {
    return Objects.equals(fieldMask, another.fieldMask)
        && Objects.equals(forcedFieldMask, another.forcedFieldMask);
  }

  /**
   * Computes a hash code from attributes: {@code fieldMask}, {@code forcedFieldMask}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(fieldMask);
    h += (h << 5) + Objects.hashCode(forcedFieldMask);
    return h;
  }

  /**
   * Prints the immutable value {@code SystemDefaults} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SystemDefaults{"
        + "fieldMask=" + fieldMask
        + ", forcedFieldMask=" + forcedFieldMask
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SystemDefaults} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SystemDefaults instance
   */
  public static ImmutableSystemDefaults copyOf(SystemDefaults instance) {
    if (instance instanceof ImmutableSystemDefaults) {
      return (ImmutableSystemDefaults) instance;
    }
    return new ImmutableSystemDefaults.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableSystemDefaults ImmutableSystemDefaults}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SystemDefaults", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable FieldMask fieldMask;
    private @Nullable FieldMask forcedFieldMask;

    /**
     * Creates a builder for {@link ImmutableSystemDefaults ImmutableSystemDefaults} instances.
     * <pre>
     * new ImmutableSystemDefaults.Builder()
     *    .fieldMask(com.telenordigital.nbiot.FieldMask | null) // nullable {@link SystemDefaults#fieldMask() fieldMask}
     *    .forcedFieldMask(com.telenordigital.nbiot.FieldMask | null) // nullable {@link SystemDefaults#forcedFieldMask() forcedFieldMask}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SystemDefaults} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SystemDefaults instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable FieldMask fieldMaskValue = instance.fieldMask();
      if (fieldMaskValue != null) {
        fieldMask(fieldMaskValue);
      }
      @Nullable FieldMask forcedFieldMaskValue = instance.forcedFieldMask();
      if (forcedFieldMaskValue != null) {
        forcedFieldMask(forcedFieldMaskValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SystemDefaults#fieldMask() fieldMask} attribute.
     * @param fieldMask The value for fieldMask (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultFieldMask")
    public final Builder fieldMask(@Nullable FieldMask fieldMask) {
      this.fieldMask = fieldMask;
      return this;
    }

    /**
     * Initializes the value for the {@link SystemDefaults#forcedFieldMask() forcedFieldMask} attribute.
     * @param forcedFieldMask The value for forcedFieldMask (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("forcedFieldMask")
    public final Builder forcedFieldMask(@Nullable FieldMask forcedFieldMask) {
      this.forcedFieldMask = forcedFieldMask;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSystemDefaults ImmutableSystemDefaults}.
     * @return An immutable instance of SystemDefaults
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSystemDefaults build() {
      return new ImmutableSystemDefaults(fieldMask, forcedFieldMask);
    }
  }
}
