package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Team}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableTeam.Builder()}.
 */
@Generated(from = "Team", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTeam implements Team {
  private final @Nullable String id;
  private final @Nullable Member[] members;
  private final @Nullable Map<String, String> tags;

  private ImmutableTeam(
      @Nullable String id,
      @Nullable Member[] members,
      @Nullable Map<String, String> tags) {
    this.id = id;
    this.members = members;
    this.tags = tags;
  }

  /**
   * The team's ID
   */
  @JsonProperty("teamId")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * The team's members
   */
  @JsonProperty("members")
  @Override
  public @Nullable Member[] members() {
    return members;
  }

  /**
   * Team tags.
   */
  @JsonProperty("tags")
  @Override
  public @Nullable Map<String, String> tags() {
    return tags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Team#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTeam withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableTeam(value, this.members, this.tags);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Team#members() members}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for members
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeam withMembers(@Nullable Member... elements) {
    @Nullable Member[] newValue = elements == null ? null : elements.clone();
    return new ImmutableTeam(this.id, newValue, this.tags);
  }

  /**
   * Copy the current immutable object by replacing the {@link Team#tags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTeam withTags(@Nullable Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableTeam(this.id, this.members, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTeam} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTeam
        && equalTo((ImmutableTeam) another);
  }

  private boolean equalTo(ImmutableTeam another) {
    return Objects.equals(id, another.id)
        && Arrays.equals(members, another.members)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code members}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Arrays.hashCode(members);
    h += (h << 5) + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code Team} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Team{"
        + "id=" + id
        + ", members=" + Arrays.toString(members)
        + ", tags=" + tags
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Team} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Team instance
   */
  public static ImmutableTeam copyOf(Team instance) {
    if (instance instanceof ImmutableTeam) {
      return (ImmutableTeam) instance;
    }
    return new ImmutableTeam.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableTeam ImmutableTeam}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Team", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable Member[] members;
    private Map<String, String> tags = null;

    /**
     * Creates a builder for {@link ImmutableTeam ImmutableTeam} instances.
     * <pre>
     * new ImmutableTeam.Builder()
     *    .id(String | null) // nullable {@link Team#id() id}
     *    .members(com.telenordigital.nbiot.Member[] | null) // nullable {@link Team#members() members}
     *    .tags(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link Team#tags() tags}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Team} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Team instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable Member[] membersValue = instance.members();
      if (membersValue != null) {
        members(membersValue);
      }
      @Nullable Map<String, String> tagsValue = instance.tags();
      if (tagsValue != null) {
        putAllTags(tagsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Team#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("teamId")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Team#members() members} attribute.
     * @param members The elements for members
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("members")
    public final Builder members(Member... members) {
      this.members = members;
      return this;
    }

    /**
     * Put one entry to the {@link Team#tags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(String key, String value) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link Team#tags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Team#tags() tags} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tags = null;
        return this;
      }
      this.tags = new LinkedHashMap<String, String>();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Team#tags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTeam ImmutableTeam}.
     * @return An immutable instance of Team
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTeam build() {
      return new ImmutableTeam(id, members, tags == null ? null : createUnmodifiableMap(false, false, tags));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
