package com.telenordigital.nbiot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UDPOutput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableUDPOutput.Builder()}.
 */
@Generated(from = "UDPOutput", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableUDPOutput extends UDPOutput {
  private final @Nullable String id;
  private final @Nullable String collectionID;
  private final @Nullable Boolean enabled;
  private final @Nullable Map<String, String> tags;
  private final String host;
  private final Integer port;

  private ImmutableUDPOutput(
      @Nullable String id,
      @Nullable String collectionID,
      @Nullable Boolean enabled,
      @Nullable Map<String, String> tags,
      String host,
      Integer port) {
    this.id = id;
    this.collectionID = collectionID;
    this.enabled = enabled;
    this.tags = tags;
    this.host = host;
    this.port = port;
  }

  /**
   * The output's ID.
   */
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * The collection the output belongs to.
   */
  @Override
  public @Nullable String collectionID() {
    return collectionID;
  }

  /**
   * Whether the output is enabled.
   */
  @Override
  public @Nullable Boolean enabled() {
    return enabled;
  }

  /**
   * Output tags.
   */
  @Override
  public @Nullable Map<String, String> tags() {
    return tags;
  }

  /**
   * The output's host.
   */
  @Override
  public String host() {
    return host;
  }

  /**
   * The output's port.
   */
  @Override
  public Integer port() {
    return port;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UDPOutput#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUDPOutput withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableUDPOutput(value, this.collectionID, this.enabled, this.tags, this.host, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UDPOutput#collectionID() collectionID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUDPOutput withCollectionID(@Nullable String value) {
    if (Objects.equals(this.collectionID, value)) return this;
    return new ImmutableUDPOutput(this.id, value, this.enabled, this.tags, this.host, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UDPOutput#enabled() enabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUDPOutput withEnabled(@Nullable Boolean value) {
    if (Objects.equals(this.enabled, value)) return this;
    return new ImmutableUDPOutput(this.id, this.collectionID, value, this.tags, this.host, this.port);
  }

  /**
   * Copy the current immutable object by replacing the {@link UDPOutput#tags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUDPOutput withTags(@Nullable Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableUDPOutput(this.id, this.collectionID, this.enabled, newValue, this.host, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UDPOutput#host() host} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for host
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUDPOutput withHost(String value) {
    String newValue = Objects.requireNonNull(value, "host");
    if (this.host.equals(newValue)) return this;
    return new ImmutableUDPOutput(this.id, this.collectionID, this.enabled, this.tags, newValue, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UDPOutput#port() port} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUDPOutput withPort(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "port");
    if (this.port.equals(newValue)) return this;
    return new ImmutableUDPOutput(this.id, this.collectionID, this.enabled, this.tags, this.host, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUDPOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUDPOutput
        && equalTo((ImmutableUDPOutput) another);
  }

  private boolean equalTo(ImmutableUDPOutput another) {
    return Objects.equals(id, another.id)
        && Objects.equals(collectionID, another.collectionID)
        && Objects.equals(enabled, another.enabled)
        && Objects.equals(tags, another.tags)
        && host.equals(another.host)
        && port.equals(another.port);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code collectionID}, {@code enabled}, {@code tags}, {@code host}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(collectionID);
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + host.hashCode();
    h += (h << 5) + port.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UDPOutput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UDPOutput{"
        + "id=" + id
        + ", collectionID=" + collectionID
        + ", enabled=" + enabled
        + ", tags=" + tags
        + ", host=" + host
        + ", port=" + port
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link UDPOutput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UDPOutput instance
   */
  public static ImmutableUDPOutput copyOf(UDPOutput instance) {
    if (instance instanceof ImmutableUDPOutput) {
      return (ImmutableUDPOutput) instance;
    }
    return new ImmutableUDPOutput.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableUDPOutput ImmutableUDPOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UDPOutput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HOST = 0x1L;
    private static final long INIT_BIT_PORT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String collectionID;
    private @Nullable Boolean enabled;
    private Map<String, String> tags = null;
    private @Nullable String host;
    private @Nullable Integer port;

    /**
     * Creates a builder for {@link ImmutableUDPOutput ImmutableUDPOutput} instances.
     * <pre>
     * new ImmutableUDPOutput.Builder()
     *    .id(String | null) // nullable {@link UDPOutput#id() id}
     *    .collectionID(String | null) // nullable {@link UDPOutput#collectionID() collectionID}
     *    .enabled(Boolean | null) // nullable {@link UDPOutput#enabled() enabled}
     *    .tags(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link UDPOutput#tags() tags}
     *    .host(String) // required {@link UDPOutput#host() host}
     *    .port(Integer) // required {@link UDPOutput#port() port}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.UDPOutput} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UDPOutput instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.Output} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Output instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof UDPOutput) {
        UDPOutput instance = (UDPOutput) object;
        host(instance.host());
        port(instance.port());
      }
      if (object instanceof Output) {
        Output instance = (Output) object;
        @Nullable String idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String collectionIDValue = instance.collectionID();
        if (collectionIDValue != null) {
          collectionID(collectionIDValue);
        }
        @Nullable Boolean enabledValue = instance.enabled();
        if (enabledValue != null) {
          enabled(enabledValue);
        }
        @Nullable Map<String, String> tagsValue = instance.tags();
        if (tagsValue != null) {
          putAllTags(tagsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link UDPOutput#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link UDPOutput#collectionID() collectionID} attribute.
     * @param collectionID The value for collectionID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionID(@Nullable String collectionID) {
      this.collectionID = collectionID;
      return this;
    }

    /**
     * Initializes the value for the {@link UDPOutput#enabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Put one entry to the {@link UDPOutput#tags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(String key, String value) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link UDPOutput#tags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UDPOutput#tags() tags} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tags = null;
        return this;
      }
      this.tags = new LinkedHashMap<String, String>();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UDPOutput#tags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UDPOutput#host() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the value for the {@link UDPOutput#port() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Integer port) {
      this.port = Objects.requireNonNull(port, "port");
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUDPOutput ImmutableUDPOutput}.
     * @return An immutable instance of UDPOutput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUDPOutput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUDPOutput(
          id,
          collectionID,
          enabled,
          tags == null ? null : createUnmodifiableMap(false, false, tags),
          host,
          port);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build UDPOutput, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
