package com.telenordigital.nbiot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WebHookOutput}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableWebHookOutput.Builder()}.
 */
@Generated(from = "WebHookOutput", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableWebHookOutput extends WebHookOutput {
  private final @Nullable String id;
  private final @Nullable String collectionID;
  private final @Nullable Boolean enabled;
  private final @Nullable Map<String, String> tags;
  private final String url;
  private final @Nullable String basicAuthUser;
  private final @Nullable String basicAuthPass;
  private final @Nullable String customHeaderName;
  private final @Nullable String customHeaderValue;

  private ImmutableWebHookOutput(
      @Nullable String id,
      @Nullable String collectionID,
      @Nullable Boolean enabled,
      @Nullable Map<String, String> tags,
      String url,
      @Nullable String basicAuthUser,
      @Nullable String basicAuthPass,
      @Nullable String customHeaderName,
      @Nullable String customHeaderValue) {
    this.id = id;
    this.collectionID = collectionID;
    this.enabled = enabled;
    this.tags = tags;
    this.url = url;
    this.basicAuthUser = basicAuthUser;
    this.basicAuthPass = basicAuthPass;
    this.customHeaderName = customHeaderName;
    this.customHeaderValue = customHeaderValue;
  }

  /**
   * The output's ID.
   */
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * The collection the output belongs to.
   */
  @Override
  public @Nullable String collectionID() {
    return collectionID;
  }

  /**
   * Whether the output is enabled.
   */
  @Override
  public @Nullable Boolean enabled() {
    return enabled;
  }

  /**
   * Output tags.
   */
  @Override
  public @Nullable Map<String, String> tags() {
    return tags;
  }

  /**
   * The output's URL.
   */
  @Override
  public String url() {
    return url;
  }

  /**
   * The output's basicAuthUser.
   */
  @Override
  public @Nullable String basicAuthUser() {
    return basicAuthUser;
  }

  /**
   * The output's basicAuthPass.
   */
  @Override
  public @Nullable String basicAuthPass() {
    return basicAuthPass;
  }

  /**
   * The output's customHeaderName.
   */
  @Override
  public @Nullable String customHeaderName() {
    return customHeaderName;
  }

  /**
   * The output's customHeaderValue.
   */
  @Override
  public @Nullable String customHeaderValue() {
    return customHeaderValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebHookOutput#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebHookOutput withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableWebHookOutput(
        value,
        this.collectionID,
        this.enabled,
        this.tags,
        this.url,
        this.basicAuthUser,
        this.basicAuthPass,
        this.customHeaderName,
        this.customHeaderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebHookOutput#collectionID() collectionID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebHookOutput withCollectionID(@Nullable String value) {
    if (Objects.equals(this.collectionID, value)) return this;
    return new ImmutableWebHookOutput(
        this.id,
        value,
        this.enabled,
        this.tags,
        this.url,
        this.basicAuthUser,
        this.basicAuthPass,
        this.customHeaderName,
        this.customHeaderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebHookOutput#enabled() enabled} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebHookOutput withEnabled(@Nullable Boolean value) {
    if (Objects.equals(this.enabled, value)) return this;
    return new ImmutableWebHookOutput(
        this.id,
        this.collectionID,
        value,
        this.tags,
        this.url,
        this.basicAuthUser,
        this.basicAuthPass,
        this.customHeaderName,
        this.customHeaderValue);
  }

  /**
   * Copy the current immutable object by replacing the {@link WebHookOutput#tags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebHookOutput withTags(@Nullable Map<String, ? extends String> entries) {
    if (this.tags == entries) return this;
    @Nullable Map<String, String> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableWebHookOutput(
        this.id,
        this.collectionID,
        this.enabled,
        newValue,
        this.url,
        this.basicAuthUser,
        this.basicAuthPass,
        this.customHeaderName,
        this.customHeaderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebHookOutput#url() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebHookOutput withUrl(String value) {
    String newValue = Objects.requireNonNull(value, "url");
    if (this.url.equals(newValue)) return this;
    return new ImmutableWebHookOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        newValue,
        this.basicAuthUser,
        this.basicAuthPass,
        this.customHeaderName,
        this.customHeaderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebHookOutput#basicAuthUser() basicAuthUser} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for basicAuthUser (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebHookOutput withBasicAuthUser(@Nullable String value) {
    if (Objects.equals(this.basicAuthUser, value)) return this;
    return new ImmutableWebHookOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.url,
        value,
        this.basicAuthPass,
        this.customHeaderName,
        this.customHeaderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebHookOutput#basicAuthPass() basicAuthPass} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for basicAuthPass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebHookOutput withBasicAuthPass(@Nullable String value) {
    if (Objects.equals(this.basicAuthPass, value)) return this;
    return new ImmutableWebHookOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.url,
        this.basicAuthUser,
        value,
        this.customHeaderName,
        this.customHeaderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebHookOutput#customHeaderName() customHeaderName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for customHeaderName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebHookOutput withCustomHeaderName(@Nullable String value) {
    if (Objects.equals(this.customHeaderName, value)) return this;
    return new ImmutableWebHookOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.url,
        this.basicAuthUser,
        this.basicAuthPass,
        value,
        this.customHeaderValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebHookOutput#customHeaderValue() customHeaderValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for customHeaderValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebHookOutput withCustomHeaderValue(@Nullable String value) {
    if (Objects.equals(this.customHeaderValue, value)) return this;
    return new ImmutableWebHookOutput(
        this.id,
        this.collectionID,
        this.enabled,
        this.tags,
        this.url,
        this.basicAuthUser,
        this.basicAuthPass,
        this.customHeaderName,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWebHookOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWebHookOutput
        && equalTo((ImmutableWebHookOutput) another);
  }

  private boolean equalTo(ImmutableWebHookOutput another) {
    return Objects.equals(id, another.id)
        && Objects.equals(collectionID, another.collectionID)
        && Objects.equals(enabled, another.enabled)
        && Objects.equals(tags, another.tags)
        && url.equals(another.url)
        && Objects.equals(basicAuthUser, another.basicAuthUser)
        && Objects.equals(basicAuthPass, another.basicAuthPass)
        && Objects.equals(customHeaderName, another.customHeaderName)
        && Objects.equals(customHeaderValue, another.customHeaderValue);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code collectionID}, {@code enabled}, {@code tags}, {@code url}, {@code basicAuthUser}, {@code basicAuthPass}, {@code customHeaderName}, {@code customHeaderValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(collectionID);
    h += (h << 5) + Objects.hashCode(enabled);
    h += (h << 5) + Objects.hashCode(tags);
    h += (h << 5) + url.hashCode();
    h += (h << 5) + Objects.hashCode(basicAuthUser);
    h += (h << 5) + Objects.hashCode(basicAuthPass);
    h += (h << 5) + Objects.hashCode(customHeaderName);
    h += (h << 5) + Objects.hashCode(customHeaderValue);
    return h;
  }

  /**
   * Prints the immutable value {@code WebHookOutput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebHookOutput{"
        + "id=" + id
        + ", collectionID=" + collectionID
        + ", enabled=" + enabled
        + ", tags=" + tags
        + ", url=" + url
        + ", basicAuthUser=" + basicAuthUser
        + ", basicAuthPass=" + basicAuthPass
        + ", customHeaderName=" + customHeaderName
        + ", customHeaderValue=" + customHeaderValue
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link WebHookOutput} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebHookOutput instance
   */
  public static ImmutableWebHookOutput copyOf(WebHookOutput instance) {
    if (instance instanceof ImmutableWebHookOutput) {
      return (ImmutableWebHookOutput) instance;
    }
    return new ImmutableWebHookOutput.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableWebHookOutput ImmutableWebHookOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WebHookOutput", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_URL = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String collectionID;
    private @Nullable Boolean enabled;
    private Map<String, String> tags = null;
    private @Nullable String url;
    private @Nullable String basicAuthUser;
    private @Nullable String basicAuthPass;
    private @Nullable String customHeaderName;
    private @Nullable String customHeaderValue;

    /**
     * Creates a builder for {@link ImmutableWebHookOutput ImmutableWebHookOutput} instances.
     * <pre>
     * new ImmutableWebHookOutput.Builder()
     *    .id(String | null) // nullable {@link WebHookOutput#id() id}
     *    .collectionID(String | null) // nullable {@link WebHookOutput#collectionID() collectionID}
     *    .enabled(Boolean | null) // nullable {@link WebHookOutput#enabled() enabled}
     *    .tags(Map&amp;lt;String, String&amp;gt; | null) // nullable {@link WebHookOutput#tags() tags}
     *    .url(String) // required {@link WebHookOutput#url() url}
     *    .basicAuthUser(String | null) // nullable {@link WebHookOutput#basicAuthUser() basicAuthUser}
     *    .basicAuthPass(String | null) // nullable {@link WebHookOutput#basicAuthPass() basicAuthPass}
     *    .customHeaderName(String | null) // nullable {@link WebHookOutput#customHeaderName() customHeaderName}
     *    .customHeaderValue(String | null) // nullable {@link WebHookOutput#customHeaderValue() customHeaderValue}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.WebHookOutput} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(WebHookOutput instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.telenordigital.nbiot.Output} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Output instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof WebHookOutput) {
        WebHookOutput instance = (WebHookOutput) object;
        @Nullable String customHeaderNameValue = instance.customHeaderName();
        if (customHeaderNameValue != null) {
          customHeaderName(customHeaderNameValue);
        }
        @Nullable String basicAuthUserValue = instance.basicAuthUser();
        if (basicAuthUserValue != null) {
          basicAuthUser(basicAuthUserValue);
        }
        @Nullable String basicAuthPassValue = instance.basicAuthPass();
        if (basicAuthPassValue != null) {
          basicAuthPass(basicAuthPassValue);
        }
        @Nullable String customHeaderValueValue = instance.customHeaderValue();
        if (customHeaderValueValue != null) {
          customHeaderValue(customHeaderValueValue);
        }
        url(instance.url());
      }
      if (object instanceof Output) {
        Output instance = (Output) object;
        @Nullable String idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String collectionIDValue = instance.collectionID();
        if (collectionIDValue != null) {
          collectionID(collectionIDValue);
        }
        @Nullable Boolean enabledValue = instance.enabled();
        if (enabledValue != null) {
          enabled(enabledValue);
        }
        @Nullable Map<String, String> tagsValue = instance.tags();
        if (tagsValue != null) {
          putAllTags(tagsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link WebHookOutput#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link WebHookOutput#collectionID() collectionID} attribute.
     * @param collectionID The value for collectionID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionID(@Nullable String collectionID) {
      this.collectionID = collectionID;
      return this;
    }

    /**
     * Initializes the value for the {@link WebHookOutput#enabled() enabled} attribute.
     * @param enabled The value for enabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(@Nullable Boolean enabled) {
      this.enabled = enabled;
      return this;
    }

    /**
     * Put one entry to the {@link WebHookOutput#tags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(String key, String value) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link WebHookOutput#tags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putTags(Map.Entry<String, ? extends String> entry) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link WebHookOutput#tags() tags} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.tags = null;
        return this;
      }
      this.tags = new LinkedHashMap<String, String>();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link WebHookOutput#tags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> entries) {
      if (this.tags == null) {
        this.tags = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link WebHookOutput#url() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link WebHookOutput#basicAuthUser() basicAuthUser} attribute.
     * @param basicAuthUser The value for basicAuthUser (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder basicAuthUser(@Nullable String basicAuthUser) {
      this.basicAuthUser = basicAuthUser;
      return this;
    }

    /**
     * Initializes the value for the {@link WebHookOutput#basicAuthPass() basicAuthPass} attribute.
     * @param basicAuthPass The value for basicAuthPass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder basicAuthPass(@Nullable String basicAuthPass) {
      this.basicAuthPass = basicAuthPass;
      return this;
    }

    /**
     * Initializes the value for the {@link WebHookOutput#customHeaderName() customHeaderName} attribute.
     * @param customHeaderName The value for customHeaderName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder customHeaderName(@Nullable String customHeaderName) {
      this.customHeaderName = customHeaderName;
      return this;
    }

    /**
     * Initializes the value for the {@link WebHookOutput#customHeaderValue() customHeaderValue} attribute.
     * @param customHeaderValue The value for customHeaderValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder customHeaderValue(@Nullable String customHeaderValue) {
      this.customHeaderValue = customHeaderValue;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWebHookOutput ImmutableWebHookOutput}.
     * @return An immutable instance of WebHookOutput
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWebHookOutput build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWebHookOutput(
          id,
          collectionID,
          enabled,
          tags == null ? null : createUnmodifiableMap(false, false, tags),
          url,
          basicAuthUser,
          basicAuthPass,
          customHeaderName,
          customHeaderValue);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      return "Cannot build WebHookOutput, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
