/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.telenordigital.nbiot.DownstreamMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DownstreamMessage", generator="Immutables")
@Immutable
public final class ImmutableDownstreamMessage
implements DownstreamMessage {
    private final int port;
    private final byte[] payload;

    private ImmutableDownstreamMessage(int port, byte[] payload) {
        this.port = port;
        this.payload = payload;
    }

    @Override
    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    @Override
    @JsonProperty(value="payload")
    public byte[] payload() {
        return (byte[])this.payload.clone();
    }

    public final ImmutableDownstreamMessage withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableDownstreamMessage(value, this.payload);
    }

    public final ImmutableDownstreamMessage withPayload(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableDownstreamMessage(this.port, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDownstreamMessage && this.equalTo((ImmutableDownstreamMessage)another);
    }

    private boolean equalTo(ImmutableDownstreamMessage another) {
        return this.port == another.port && Arrays.equals(this.payload, another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.port;
        h += (h << 5) + Arrays.hashCode(this.payload);
        return h;
    }

    public String toString() {
        return "DownstreamMessage{port=" + this.port + ", payload=" + Arrays.toString(this.payload) + "}";
    }

    public static ImmutableDownstreamMessage copyOf(DownstreamMessage instance) {
        if (instance instanceof ImmutableDownstreamMessage) {
            return (ImmutableDownstreamMessage)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="DownstreamMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PORT = 1L;
        private static final long INIT_BIT_PAYLOAD = 2L;
        private long initBits = 3L;
        private int port;
        @Nullable
        private byte[] payload;

        public final Builder from(DownstreamMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.port(instance.port());
            this.payload(instance.payload());
            return this;
        }

        @JsonProperty(value="port")
        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="payload")
        public final Builder payload(byte ... payload) {
            this.payload = (byte[])payload.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDownstreamMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDownstreamMessage(this.port, this.payload);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payload");
            }
            return "Cannot build DownstreamMessage, some of required attributes are not set " + attributes;
        }
    }
}

