/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.telenordigital.nbiot.Output;
import com.telenordigital.nbiot.UDPOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UDPOutput", generator="Immutables")
@Immutable
public final class ImmutableUDPOutput
extends UDPOutput {
    @Nullable
    private final String id;
    @Nullable
    private final String collectionID;
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Map<String, String> tags;
    private final String host;
    private final Integer port;

    private ImmutableUDPOutput(@Nullable String id, @Nullable String collectionID, @Nullable Boolean enabled, @Nullable Map<String, String> tags, String host, Integer port) {
        this.id = id;
        this.collectionID = collectionID;
        this.enabled = enabled;
        this.tags = tags;
        this.host = host;
        this.port = port;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String collectionID() {
        return this.collectionID;
    }

    @Override
    @Nullable
    public Boolean enabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public Integer port() {
        return this.port;
    }

    public final ImmutableUDPOutput withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableUDPOutput(value, this.collectionID, this.enabled, this.tags, this.host, this.port);
    }

    public final ImmutableUDPOutput withCollectionID(@Nullable String value) {
        if (Objects.equals(this.collectionID, value)) {
            return this;
        }
        return new ImmutableUDPOutput(this.id, value, this.enabled, this.tags, this.host, this.port);
    }

    public final ImmutableUDPOutput withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableUDPOutput(this.id, this.collectionID, value, this.tags, this.host, this.port);
    }

    public final ImmutableUDPOutput withTags(@Nullable Map<String, ? extends String> entries) {
        if (this.tags == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableUDPOutput.createUnmodifiableMap(true, false, entries);
        return new ImmutableUDPOutput(this.id, this.collectionID, this.enabled, newValue, this.host, this.port);
    }

    public final ImmutableUDPOutput withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableUDPOutput(this.id, this.collectionID, this.enabled, this.tags, newValue, this.port);
    }

    public final ImmutableUDPOutput withPort(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "port");
        if (this.port.equals(newValue)) {
            return this;
        }
        return new ImmutableUDPOutput(this.id, this.collectionID, this.enabled, this.tags, this.host, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUDPOutput && this.equalTo((ImmutableUDPOutput)another);
    }

    private boolean equalTo(ImmutableUDPOutput another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.collectionID, another.collectionID) && Objects.equals(this.enabled, another.enabled) && Objects.equals(this.tags, another.tags) && this.host.equals(another.host) && this.port.equals(another.port);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.collectionID);
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.port.hashCode();
        return h;
    }

    public String toString() {
        return "UDPOutput{id=" + this.id + ", collectionID=" + this.collectionID + ", enabled=" + this.enabled + ", tags=" + this.tags + ", host=" + this.host + ", port=" + this.port + "}";
    }

    public static ImmutableUDPOutput copyOf(UDPOutput instance) {
        if (instance instanceof ImmutableUDPOutput) {
            return (ImmutableUDPOutput)instance;
        }
        return new Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="UDPOutput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private static final long INIT_BIT_PORT = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String collectionID;
        @Nullable
        private Boolean enabled;
        private Map<String, String> tags = null;
        @Nullable
        private String host;
        @Nullable
        private Integer port;

        public final Builder from(UDPOutput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Output instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Output instance;
            if (object instanceof UDPOutput) {
                instance = (UDPOutput)object;
                this.host(((UDPOutput)instance).host());
                this.port(((UDPOutput)instance).port());
            }
            if (object instanceof Output) {
                Map<String, String> tagsValue;
                Boolean enabledValue;
                String collectionIDValue;
                instance = (Output)object;
                String idValue = instance.id();
                if (idValue != null) {
                    this.id(idValue);
                }
                if ((collectionIDValue = instance.collectionID()) != null) {
                    this.collectionID(collectionIDValue);
                }
                if ((enabledValue = instance.enabled()) != null) {
                    this.enabled(enabledValue);
                }
                if ((tagsValue = instance.tags()) != null) {
                    this.putAllTags(tagsValue);
                }
            }
        }

        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder collectionID(@Nullable String collectionID) {
            this.collectionID = collectionID;
            return this;
        }

        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Builder putTags(String key, String value) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            this.tags.put(Objects.requireNonNull(key, "tags key"), Objects.requireNonNull(value, "tags value"));
            return this;
        }

        public final Builder putTags(Map.Entry<String, ? extends String> entry) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.tags.put(Objects.requireNonNull(k, "tags key"), Objects.requireNonNull(v, "tags value"));
            return this;
        }

        public final Builder tags(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.tags = null;
                return this;
            }
            this.tags = new LinkedHashMap<String, String>();
            return this.putAllTags(entries);
        }

        public final Builder putAllTags(Map<String, ? extends String> entries) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.tags.put(Objects.requireNonNull(k, "tags key"), Objects.requireNonNull(v, "tags value"));
            }
            return this;
        }

        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(Integer port) {
            this.port = Objects.requireNonNull(port, "port");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUDPOutput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUDPOutput(this.id, this.collectionID, this.enabled, this.tags == null ? null : ImmutableUDPOutput.createUnmodifiableMap(false, false, this.tags), this.host, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build UDPOutput, some of required attributes are not set " + attributes;
        }
    }
}

