package fi.evolver.script.app;

import fi.evolver.script.Dialog;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;

public class Gh {
	public static void configure() {
		try (Step step = Step.start("Configure GitHub CLI")) {
			Apt.install("gh");
			if (!Shell.Command.user("gh", "auth", "status")
					.failOnError(false)
					.run()
					.success()
			) {
				String token = Dialog.readPassword("GitHub CLI authentication token (empty to skip)");
				if (!token.isBlank()) {
					Shell.Command.user("gh", "auth", "login", "--with-token")
							.stdin(token)
							.run();
				}
			}
		}
	}
}
