package io.bitsensor.plugins.java.http.filter.handler;


import io.bitsensor.plugins.java.core.handler.Handler;
import org.springframework.core.annotation.Order;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * A data collection handler.
 */
@Order(0)
public interface RequestHandler extends Handler {

    /**
     * Performs data collection.
     *
     * @param request  The current HTTP request.
     * @param response The current HTTP response.
     */
    void handle(HttpServletRequest request, HttpServletResponse response);
}
