package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.plugins.java.core.BitSensor;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Collects the IP address.
 */
@Component
public class RequestIpHandler implements RequestHandler {

    /**
     * Adds the IP address of the HTTP request to the {@link Datapoint}. For documentation on configurations behind
     * loadbalancers, check See Also for your server.
     *
     * @param request  The current HTTP request.
     * @param response The current HTTP response.
     * @see <a href="https://tomcat.apache.org/tomcat-7.0-doc/api/org/apache/catalina/valves/RemoteIpValve.html">Tomcat</a>
     * @see <a href="http://docs.spring.io/spring-boot/docs/current/reference/html/howto-embedded-servlet-containers.html#howto-customize-tomcat-behind-a-proxy-server">Spring
     * Boot</a>
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        if (request.getRemoteAddr() != null) {
            BitSensor.addContext("ip", request.getRemoteAddr());
        }
    }

    /**
     * @return {@link ExecutionMoment#PRE_HANDLE}
     */
    @Override
    public ExecutionMoment getExecutionMoment() {
        return ExecutionMoment.PRE_HANDLE;
    }
}
