package io.bitsensor.plugins.java.http.listener;

import io.bitsensor.plugins.java.core.connectors.ApiConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import java.io.IOException;

/**
 * Listener to startup and shutdown the web application's BitSensor plugin.
 *
 * @see io.bitsensor.plugins.java.http.filter.BitSensorFilter BitSensorFilter
 */
public class BitSensorServletContextListener implements ServletContextListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(BitSensorServletContextListener.class);

    private ApiConnector apiConnector;

    public BitSensorServletContextListener(ApiConnector apiConnector) {
        this.apiConnector = apiConnector;
    }

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        apiConnector.initialize();
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            apiConnector.shutdown();
        } catch (InterruptedException | IOException e) {
            LOGGER.error("BitSensor shut down with error", e);
        }
    }
}
