/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.sql;

import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class JdbcAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcAspect.class);
    private static final String MYSQL_JDBC_INTERCEPTOR = "io.bitsensor.plugins.java.sql.MysqlJdbcInterceptor";
    private static final String POSTGRES_JDBC_INTERCEPTOR = "io.bitsensor.plugins.java.sql.PostgresJdbcInterceptor";

    @Pointcut(value="within(org.apache.tomcat.jdbc.pool.DataSourceProxy) && execution(* getConnection())")
    public void getConnectionMethod() {
    }

    @Around(value="getConnectionMethod()")
    public Object getConnectionAround(ProceedingJoinPoint joinPoint) throws Throwable {
        DataSourceProxy dsp = (DataSourceProxy)joinPoint.getThis();
        String driverClassName = dsp.getDriverClassName();
        String jdbcInterceptors = dsp.getJdbcInterceptors();
        switch (driverClassName) {
            case "com.mysql.jdbc.Driver": {
                if (jdbcInterceptors != null && jdbcInterceptors.contains(MYSQL_JDBC_INTERCEPTOR)) break;
                jdbcInterceptors = jdbcInterceptors == null ? MYSQL_JDBC_INTERCEPTOR : jdbcInterceptors.concat(",io.bitsensor.plugins.java.sql.MysqlJdbcInterceptor");
                dsp.getPoolProperties().setJdbcInterceptors(jdbcInterceptors);
                break;
            }
            case "org.postgresql.Driver": {
                if (jdbcInterceptors != null && jdbcInterceptors.contains(POSTGRES_JDBC_INTERCEPTOR)) break;
                jdbcInterceptors = jdbcInterceptors == null ? POSTGRES_JDBC_INTERCEPTOR : jdbcInterceptors.concat(",io.bitsensor.plugins.java.sql.PostgresJdbcInterceptor");
                dsp.getPoolProperties().setJdbcInterceptors(jdbcInterceptors);
                break;
            }
            default: {
                LOGGER.error("BitSensor can not handle unknown JDBC driver class name [{}]", (Object)driverClassName);
            }
        }
        return joinPoint.proceed();
    }
}

