/*
 * Decompiled with CFR 0.152.
 */
package io.codef.easycodef;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.codef.easycodef.EasyCodefConnector;
import io.codef.easycodef.EasyCodefMessageConstant;
import io.codef.easycodef.EasyCodefProperties;
import io.codef.easycodef.EasyCodefResponse;
import io.codef.easycodef.EasyCodefServiceType;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class EasyCodef {
    private ObjectMapper mapper = new ObjectMapper();
    private EasyCodefProperties properties = new EasyCodefProperties();

    public void setClientInfo(String clientId, String clientSecret) {
        this.properties.setClientInfo(clientId, clientSecret);
    }

    public void setClientInfoForDemo(String demoClientId, String demoClientSecret) {
        this.properties.setClientInfoForDemo(demoClientId, demoClientSecret);
    }

    public void setPublicKey(String publicKey) {
        this.properties.setPublicKey(publicKey);
    }

    public String getPublicKey() {
        return this.properties.getPublicKey();
    }

    public String requestProduct(String productUrl, EasyCodefServiceType serviceType, HashMap<String, Object> parameterMap) throws UnsupportedEncodingException, JsonProcessingException, InterruptedException {
        boolean validationFlag = true;
        validationFlag = this.checkClientInfo(serviceType.getServiceType());
        if (!validationFlag) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.EMPTY_CLIENT_INFO);
            return this.mapper.writeValueAsString((Object)response);
        }
        validationFlag = this.checkPublicKey();
        if (!validationFlag) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.EMPTY_PUBLIC_KEY);
            return this.mapper.writeValueAsString((Object)response);
        }
        validationFlag = this.checkTwoWayKeyword(parameterMap);
        if (!validationFlag) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.INVALID_2WAY_KEYWORD);
            return this.mapper.writeValueAsString((Object)response);
        }
        EasyCodefResponse response = EasyCodefConnector.execute(productUrl, serviceType.getServiceType(), parameterMap, this.properties);
        return this.mapper.writeValueAsString((Object)response);
    }

    public String requestCertification(String productUrl, EasyCodefServiceType serviceType, HashMap<String, Object> parameterMap) throws UnsupportedEncodingException, JsonProcessingException, InterruptedException {
        boolean validationFlag = true;
        validationFlag = this.checkClientInfo(serviceType.getServiceType());
        if (!validationFlag) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.EMPTY_CLIENT_INFO);
            return this.mapper.writeValueAsString((Object)response);
        }
        validationFlag = this.checkPublicKey();
        if (!validationFlag) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.EMPTY_PUBLIC_KEY);
            return this.mapper.writeValueAsString((Object)response);
        }
        validationFlag = this.checkTwoWayInfo(parameterMap);
        if (!validationFlag) {
            EasyCodefResponse response = new EasyCodefResponse(EasyCodefMessageConstant.INVALID_2WAY_INFO);
            return this.mapper.writeValueAsString((Object)response);
        }
        EasyCodefResponse response = EasyCodefConnector.execute(productUrl, serviceType.getServiceType(), parameterMap, this.properties);
        return this.mapper.writeValueAsString((Object)response);
    }

    private boolean checkClientInfo(int serviceType) {
        if (serviceType == 0) {
            if (this.properties.getClientId() == null || "".equals(this.properties.getClientId().trim())) {
                return false;
            }
            if (this.properties.getClientSecret() == null || "".equals(this.properties.getClientSecret().trim())) {
                return false;
            }
        } else if (serviceType == 1) {
            if (this.properties.getDemoClientId() == null || "".equals(this.properties.getDemoClientId().trim())) {
                return false;
            }
            if (this.properties.getDemoClientSecret() == null || "".equals(this.properties.getDemoClientSecret().trim())) {
                return false;
            }
        } else {
            if ("ef27cfaa-10c1-4470-adac-60ba476273f9" == null || "".equals("ef27cfaa-10c1-4470-adac-60ba476273f9".trim())) {
                return false;
            }
            if ("83160c33-9045-4915-86d8-809473cdf5c3" == null || "".equals("83160c33-9045-4915-86d8-809473cdf5c3".trim())) {
                return false;
            }
        }
        return true;
    }

    private boolean checkPublicKey() {
        return this.properties.getPublicKey() != null && !"".equals(this.properties.getPublicKey().trim());
    }

    private boolean checkTwoWayInfo(HashMap<String, Object> parameterMap) {
        if (!(parameterMap.containsKey("is2Way") && parameterMap.get("is2Way") instanceof Boolean && ((Boolean)parameterMap.get("is2Way")).booleanValue())) {
            return false;
        }
        if (!parameterMap.containsKey("twoWayInfo")) {
            return false;
        }
        HashMap twoWayInfoMap = (HashMap)parameterMap.get("twoWayInfo");
        return twoWayInfoMap.containsKey("jobIndex") && twoWayInfoMap.containsKey("threadIndex") && twoWayInfoMap.containsKey("jti") && twoWayInfoMap.containsKey("twoWayTimestamp");
    }

    private boolean checkTwoWayKeyword(HashMap<String, Object> parameterMap) {
        return !parameterMap.containsKey("is2Way") && !parameterMap.containsKey("twoWayInfo");
    }

    public String createAccount(EasyCodefServiceType serviceType, HashMap<String, Object> parameterMap) throws UnsupportedEncodingException, JsonProcessingException, InterruptedException {
        return this.requestProduct("/v1/account/create", serviceType, parameterMap);
    }

    public String addAccount(EasyCodefServiceType serviceType, HashMap<String, Object> parameterMap) throws UnsupportedEncodingException, JsonProcessingException, InterruptedException {
        return this.requestProduct("/v1/account/add", serviceType, parameterMap);
    }

    public String updateAccount(EasyCodefServiceType serviceType, HashMap<String, Object> parameterMap) throws UnsupportedEncodingException, JsonProcessingException, InterruptedException {
        return this.requestProduct("/v1/account/update", serviceType, parameterMap);
    }

    public String deleteAccount(EasyCodefServiceType serviceType, HashMap<String, Object> parameterMap) throws UnsupportedEncodingException, JsonProcessingException, InterruptedException {
        return this.requestProduct("/v1/account/delete", serviceType, parameterMap);
    }

    public String getAccountList(EasyCodefServiceType serviceType, HashMap<String, Object> parameterMap) throws UnsupportedEncodingException, JsonProcessingException, InterruptedException {
        return this.requestProduct("/v1/account/list", serviceType, parameterMap);
    }

    public String getConnectedIdList(EasyCodefServiceType serviceType) throws UnsupportedEncodingException, JsonProcessingException, InterruptedException {
        return this.requestProduct("/v1/account/connectedId-list", serviceType, null);
    }

    public HashMap<String, Object> requestToken(EasyCodefServiceType serviceType) {
        if (serviceType.getServiceType() == 0) {
            return EasyCodefConnector.requestToken(this.properties.getClientId(), this.properties.getClientSecret());
        }
        if (serviceType.getServiceType() == 1) {
            return EasyCodefConnector.requestToken(this.properties.getDemoClientId(), this.properties.getDemoClientSecret());
        }
        return EasyCodefConnector.requestToken("ef27cfaa-10c1-4470-adac-60ba476273f9", "83160c33-9045-4915-86d8-809473cdf5c3");
    }
}

