/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.testutils;

import com.github.javaparser.JavaParser;
import io.codemodder.CodeChanger;
import io.codemodder.CodemodExecutor;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodLoader;
import io.codemodder.EncodingDetector;
import io.codemodder.IncludesExcludes;
import io.codemodder.SarifParser;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.javaparser.CachingJavaParser;
import io.codemodder.testutils.Metadata;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public interface RawFileCodemodTest {
    @Test
    default public void it_verifies_codemod(@TempDir Path tmpDir) throws IOException {
        Metadata metadata = this.getClass().getAnnotation(Metadata.class);
        if (metadata == null) {
            throw new IllegalArgumentException("CodemodTest must be annotated with @Metadata");
        }
        Class<? extends CodeChanger> codemod = metadata.codemodType();
        Path testResourceDir = Path.of(metadata.testResourceDir(), new String[0]);
        Path testDir = Path.of("src/test/resources/" + testResourceDir, new String[0]);
        this.verifyCodemod(codemod, metadata, tmpDir, testDir);
    }

    private void verifySingleCase(CodemodLoader loader, Path tmpDir, Metadata metadata, Path filePathBefore, Path filePathAfter) throws IOException {
        String tmpFileName = RawFileCodemodTest.trimExtension(filePathBefore);
        String renameFile = metadata.renameTestFile();
        if (!renameFile.isBlank()) {
            Path parent = tmpDir.resolve(renameFile).getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            tmpFileName = renameFile;
        }
        Path tmpFilePath = tmpDir.resolve(tmpFileName);
        Files.copy(filePathBefore, tmpFilePath, new CopyOption[0]);
        List codemods = loader.getCodemods();
        MatcherAssert.assertThat((String)"Only expecting 1 codemod per test", (Object)codemods.size(), (Matcher)Matchers.equalTo((Object)1));
        CodemodIdPair pair = (CodemodIdPair)codemods.get(0);
        CodemodExecutor executor = CodemodExecutor.from((Path)tmpDir, (IncludesExcludes)IncludesExcludes.any(), (CodemodIdPair)pair, List.of(), List.of(), (CachingJavaParser)CachingJavaParser.from((JavaParser)new JavaParser()), (EncodingDetector)EncodingDetector.create());
        CodeTFResult result = executor.execute(List.of(tmpFilePath));
        MatcherAssert.assertThat((String)"Some files failed to scan", (Object)result.getFailedFiles().size(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getSummary(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.blankOrNullString())));
        MatcherAssert.assertThat((Object)result.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.blankOrNullString())));
        MatcherAssert.assertThat((Object)result.getReferences(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        String modifiedFile = Files.readString(tmpFilePath);
        MatcherAssert.assertThat((Object)modifiedFile, (Matcher)Matchers.equalTo((Object)Files.readString(filePathAfter)));
        Files.deleteIfExists(tmpFilePath);
    }

    private static String trimExtension(Path path) {
        return path.getFileName().toString().substring(0, path.getFileName().toString().lastIndexOf(46));
    }

    private void verifyCodemod(Class<? extends CodeChanger> codemod, Metadata metadata, Path tmpDir, Path testResourceDir) throws IOException {
        List allSarifFiles = Files.list(testResourceDir).filter(file -> file.getFileName().toString().endsWith(".sarif")).collect(Collectors.toList());
        Map map = SarifParser.create().parseIntoMap(allSarifFiles, tmpDir);
        CodemodLoader invoker = new CodemodLoader(List.of(codemod), tmpDir, map);
        List allBeforeFiles = Files.list(testResourceDir).filter(file -> file.getFileName().toString().endsWith(".before")).collect(Collectors.toList());
        Map<String, Path> afterFilesMap = Files.list(testResourceDir).filter(file -> file.getFileName().toString().endsWith(".after")).collect(Collectors.toMap(f -> RawFileCodemodTest.trimExtension(f), f -> f));
        for (Path beforeFile : allBeforeFiles) {
            Path afterFile = afterFilesMap.get(RawFileCodemodTest.trimExtension(beforeFile));
            this.verifySingleCase(invoker, tmpDir, metadata, beforeFile, afterFile);
        }
    }
}

