/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.testutils;

import io.codemodder.CodeChanger;
import io.codemodder.FixOnlyCodeChanger;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.codetf.CodeTFResult;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

final class ExpectedFixes {
    private ExpectedFixes() {
    }

    static void verifyExpectedFixes(CodeTFResult result, CodeChanger changer, int[] expectedFixLines, int[] expectingFailedFixesAtLines) {
        List changes = result.getChangeset().stream().map(CodeTFChangesetEntry::getChanges).flatMap(Collection::stream).toList();
        if (changer instanceof FixOnlyCodeChanger) {
            MatcherAssert.assertThat((Object)changes.stream().anyMatch(c -> !c.getFixedFindings().isEmpty()), (Matcher)Matchers.is((Object)true));
        }
        for (int expectedFixLine : expectedFixLines) {
            MatcherAssert.assertThat((Object)changes.stream().anyMatch(c -> c.getLineNumber() == expectedFixLine), (Matcher)Matchers.is((Object)true));
        }
        List unfixedFindings = result.getUnfixedFindings();
        for (int expectedFailedFixLine : expectingFailedFixesAtLines) {
            MatcherAssert.assertThat((Object)unfixedFindings.stream().noneMatch(c -> c.getLine() == expectedFailedFixLine), (Matcher)Matchers.is((Object)true));
        }
    }
}

