/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.testutils;

import io.codemodder.CodeChanger;
import io.codemodder.FixOnlyCodeChanger;
import io.codemodder.codetf.CodeTFChangesetEntry;
import io.codemodder.codetf.CodeTFResult;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

final class ExpectedFixes {
    private ExpectedFixes() {
    }

    static void verifyExpectedFixes(Path testResourceDir, CodeTFResult result, CodeChanger changer, int[] expectedFixLines, int[] expectingFailedFixesAtLines) throws IOException {
        ExpectedFixes.checkExpectedFixLinesUsage(testResourceDir, expectedFixLines, expectingFailedFixesAtLines);
        List changes = result.getChangeset().stream().map(CodeTFChangesetEntry::getChanges).flatMap(Collection::stream).toList();
        if (changer instanceof FixOnlyCodeChanger) {
            MatcherAssert.assertThat((Object)changes.stream().anyMatch(c -> !c.getFixedFindings().isEmpty()), (Matcher)Matchers.is((Object)true));
        }
        for (int expectedFixLine : expectedFixLines) {
            MatcherAssert.assertThat((Object)changes.stream().anyMatch(c -> c.getLineNumber() == expectedFixLine), (Matcher)Matchers.is((Object)true));
        }
        List unfixedFindings = result.getUnfixedFindings();
        for (int expectedFailedFixLine : expectingFailedFixesAtLines) {
            MatcherAssert.assertThat((Object)unfixedFindings.stream().anyMatch(c -> c.getLine() == expectedFailedFixLine), (Matcher)Matchers.is((Object)true));
        }
    }

    static void checkExpectedFixLinesUsage(Path testResourceDir, int[] expectingFixesAtLines, int[] expectingFailedFixesAtLines) throws IOException {
        try (Stream<Path> stream = Files.walk(testResourceDir, new FileVisitOption[0]);){
            List<Path> paths = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".before")).toList();
            if ((expectingFixesAtLines.length > 0 || expectingFailedFixesAtLines.length > 0) && paths.size() > 1) {
                throw new IllegalArgumentException("Expected fixes at lines is not supported with multi-file test feature. Define single test when setting expected fix lines.");
            }
        }
    }
}

