/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.testutils;

import com.github.javaparser.JavaParser;
import io.codemodder.CodeChanger;
import io.codemodder.CodeDirectory;
import io.codemodder.CodemodExecutor;
import io.codemodder.CodemodExecutorFactory;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodLoader;
import io.codemodder.CodemodRegulator;
import io.codemodder.DefaultRuleSetting;
import io.codemodder.EncodingDetector;
import io.codemodder.FileCache;
import io.codemodder.IncludesExcludes;
import io.codemodder.RuleSarif;
import io.codemodder.SarifParser;
import io.codemodder.codetf.CodeTFResult;
import io.codemodder.javaparser.JavaParserFacade;
import io.codemodder.testutils.ExpectedFixes;
import io.codemodder.testutils.Metadata;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public interface RawFileCodemodTest {
    @Test
    default public void it_verifies_codemod(@TempDir Path tmpDir) throws IOException {
        Metadata metadata = this.getClass().getAnnotation(Metadata.class);
        if (metadata == null) {
            throw new IllegalArgumentException("CodemodTest must be annotated with @Metadata");
        }
        Class<? extends CodeChanger> codemod = metadata.codemodType();
        Path testResourceDir = Path.of(metadata.testResourceDir(), new String[0]);
        Path testDir = Path.of("src/test/resources/" + testResourceDir, new String[0]);
        this.verifyCodemod(codemod, metadata, tmpDir, testDir);
    }

    private void verifySingleCase(Class<? extends CodeChanger> codemod, Path tmpDir, Metadata metadata, Path filePathBefore, Path filePathAfter, Map<String, List<RuleSarif>> ruleSarifMap, int[] expectedFixLines, int[] expectingFailedFixesAtLines, Path testResourceDir) throws IOException {
        String tmpFileName = RawFileCodemodTest.trimExtension(filePathBefore);
        String renameFile = metadata.renameTestFile();
        if (!renameFile.isBlank()) {
            Path parent = tmpDir.resolve(renameFile).getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            tmpFileName = renameFile;
        }
        Path tmpFilePath = tmpDir.resolve(tmpFileName);
        Files.copy(filePathBefore, tmpFilePath, new CopyOption[0]);
        CodemodLoader loader = new CodemodLoader(List.of(codemod), CodemodRegulator.of((DefaultRuleSetting)DefaultRuleSetting.ENABLED, List.of()), tmpDir, List.of("**"), List.of(), List.of(tmpFilePath), ruleSarifMap, List.of(), null, null, null, null);
        List codemods = loader.getCodemods();
        MatcherAssert.assertThat((String)"Only expecting 1 codemod per test", (Object)codemods.size(), (Matcher)Matchers.equalTo((Object)1));
        CodemodIdPair pair = (CodemodIdPair)codemods.get(0);
        CodemodExecutor executor = CodemodExecutorFactory.from(tmpDir, IncludesExcludes.any(), pair, List.of(), List.of(), FileCache.createDefault(), JavaParserFacade.from(JavaParser::new), EncodingDetector.create());
        CodeTFResult result = executor.execute(List.of(tmpFilePath));
        MatcherAssert.assertThat((String)"Some files failed to scan", (Object)result.getFailedFiles().size(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)result.getSummary(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.blankOrNullString())));
        MatcherAssert.assertThat((Object)result.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.blankOrNullString())));
        MatcherAssert.assertThat((Object)result.getReferences(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        String modifiedFile = Files.readString(tmpFilePath);
        if (filePathAfter == null) {
            MatcherAssert.assertThat((Object)modifiedFile, (Matcher)Matchers.equalTo((Object)Files.readString(filePathBefore)));
        } else {
            MatcherAssert.assertThat((Object)modifiedFile, (Matcher)Matchers.equalTo((Object)Files.readString(filePathAfter)));
        }
        Files.deleteIfExists(tmpFilePath);
        ExpectedFixes.verifyExpectedFixes(testResourceDir, result, pair.getChanger(), expectedFixLines, expectingFailedFixesAtLines);
    }

    private static String trimExtension(Path path) {
        return path.getFileName().toString().substring(0, path.getFileName().toString().lastIndexOf(46));
    }

    private void verifyCodemod(Class<? extends CodeChanger> codemod, Metadata metadata, Path tmpDir, Path testResourceDir) throws IOException {
        Map<String, Path> afterFilesMap;
        List<Path> allBeforeFiles;
        List<Path> allSarifFiles;
        try (Stream<Path> files = Files.list(testResourceDir);){
            allSarifFiles = files.filter(file -> file.getFileName().toString().endsWith(".sarif")).toList();
        }
        CodeDirectory codeDirectory = CodeDirectory.from((Path)tmpDir);
        Map map = SarifParser.create().parseIntoMap(allSarifFiles, codeDirectory);
        try (Stream<Path> files = Files.list(testResourceDir);){
            allBeforeFiles = files.filter(file -> file.getFileName().toString().endsWith(".before")).toList();
        }
        try (Stream<Path> files = Files.list(testResourceDir);){
            afterFilesMap = files.filter(file -> file.getFileName().toString().endsWith(".after")).collect(Collectors.toMap(RawFileCodemodTest::trimExtension, f -> f));
        }
        if (allBeforeFiles.isEmpty()) {
            throw new IllegalArgumentException("No .before files found in " + testResourceDir);
        }
        for (Path beforeFile : allBeforeFiles) {
            Path afterFile = afterFilesMap.get(RawFileCodemodTest.trimExtension(beforeFile));
            this.verifySingleCase(codemod, tmpDir, metadata, beforeFile, afterFile, map, metadata.expectingFixesAtLines(), metadata.expectingFailedFixesAtLines(), testResourceDir);
        }
    }
}

