/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.CodeTFValidator;
import java.util.Objects;

public final class CodeTFReference {
    private final String url;
    private final String description;

    @JsonCreator
    public CodeTFReference(@JsonProperty(value="url") String url, @JsonProperty(value="description") String description) {
        this.url = CodeTFValidator.requireNonBlank(url);
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeTFReference that = (CodeTFReference)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.description);
    }

    public String toString() {
        return "CodeTFReference{url='" + this.url + "', description='" + this.description + "'}";
    }
}

