/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import io.contextmap.core.reflection.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ObjectToJsonConverter {
    private final ObjectToJsonReflection reflectionService;
    private final ObjectToJsonLogger logger;
    private static Map<Class, String> cacheOfProcessedSerializedTypes = new HashMap<Class, String>();
    private static Map<Class, String> cacheOfProcessedDeserializedTypes = new HashMap<Class, String>();
    private static Set<String> numberPrimitives = new HashSet<String>(Arrays.asList(Integer.class.getName(), Integer.TYPE.getName(), Long.class.getName(), Long.TYPE.getName(), Byte.class.getName(), Byte.TYPE.getName(), Short.class.getName(), Short.TYPE.getName(), Float.class.getName(), Float.TYPE.getName(), Double.class.getName(), Double.TYPE.getName(), BigDecimal.class.getName(), BigInteger.class.getName()));
    private static Set<String> booleanPrimitives = new HashSet<String>(Arrays.asList(Boolean.class.getName(), Boolean.TYPE.getName()));
    private static Set<String> stringPrimitives = new HashSet<String>(Arrays.asList(String.class.getName(), UUID.class.getName(), Character.class.getName(), Character.TYPE.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), LocalDateTime.class.getName(), LocalDate.class.getName(), LocalTime.class.getName(), Year.class.getName(), YearMonth.class.getName(), Month.class.getName(), MonthDay.class.getName(), OffsetTime.class.getName(), DayOfWeek.class.getName(), OffsetDateTime.class.getName(), Duration.class.getName(), Instant.class.getName(), ZonedDateTime.class.getName()));

    public ObjectToJsonConverter(ObjectToJsonReflection objectToJsonReflection, ObjectToJsonLogger logger) {
        this.reflectionService = objectToJsonReflection;
        this.logger = logger;
    }

    public String serializedJson(Class<?> type, Property property, List<Class<?>> typesToExcludeToPreventLoop) {
        Parameters parameters = new Parameters();
        parameters.type = type;
        parameters.property = property;
        parameters.typesToExcludeToPreventLoop = typesToExcludeToPreventLoop;
        parameters.shouldIncludeProperty = prop -> prop.getField() != null || prop.getGetterMethod() != null;
        parameters.cacheOfTypes = ObjectToJsonConverter.cacheOfProcessedSerializedTypes;
        parameters.methodFromPropertyFunction = Property::getGetterMethod;
        parameters.genericTypeFromPropertyFunction = prop -> {
            Type genericType = null;
            if (prop != null && prop.getGetterMethod() != null) {
                genericType = prop.getGetterMethod().getGenericReturnType();
            } else if (prop != null && prop.getField() != null) {
                genericType = prop.getField().getGenericType();
            }
            return genericType;
        };
        return this.toJson(parameters);
    }

    public String deserializedJson(Class<?> type, Property property, List<Class<?>> typesToExcludeToPreventLoop) {
        Parameters parameters = new Parameters();
        parameters.type = type;
        parameters.property = property;
        parameters.typesToExcludeToPreventLoop = typesToExcludeToPreventLoop;
        parameters.shouldIncludeProperty = prop -> prop.getField() != null || prop.getSetterMethod() != null;
        parameters.cacheOfTypes = ObjectToJsonConverter.cacheOfProcessedDeserializedTypes;
        parameters.methodFromPropertyFunction = Property::getSetterMethod;
        parameters.genericTypeFromPropertyFunction = prop -> {
            Type genericType = null;
            if (prop != null && prop.getSetterMethod() != null && prop.getSetterMethod().getGenericParameterTypes().length > 0) {
                genericType = prop.getSetterMethod().getGenericParameterTypes()[0];
            } else if (prop != null && prop.getField() != null) {
                genericType = prop.getField().getGenericType();
            }
            return genericType;
        };
        return this.toJson(parameters);
    }

    private String toJson(Parameters parameters) {
        this.logger.debug("Serialize type " + parameters.type);
        if (this.isVoidType(parameters.type)) {
            return null;
        }
        if (parameters.typesToExcludeToPreventLoop.contains(parameters.type)) {
            return "object";
        }
        if (this.isPrimitive(parameters.type)) {
            return this.getPrimitiveJsonType(parameters.type);
        }
        if (this.isCollection(parameters.type)) {
            Type genericType = (Type)parameters.genericTypeFromPropertyFunction.apply(parameters.property);
            return this.getCollectionJsonType(parameters.type, genericType, parameters.typesToExcludeToPreventLoop, parameters);
        }
        if (this.isObject(parameters.type)) {
            return "object";
        }
        if (this.isHttpEntity(parameters.type) || this.isDeferredResult(parameters.type)) {
            Type genericType = (Type)parameters.genericTypeFromPropertyFunction.apply(parameters.property);
            return this.getHttpEntityJsonType(parameters.type, genericType, parameters.typesToExcludeToPreventLoop, parameters);
        }
        if (parameters.cacheOfTypes.containsKey(parameters.type)) {
            this.logger.debug("Reusing cached result for type " + parameters.type.getSimpleName());
            return (String)parameters.cacheOfTypes.get(parameters.type);
        }
        ArrayList<Class> typesToExcludeForChildren = new ArrayList<Class>(parameters.typesToExcludeToPreventLoop);
        typesToExcludeForChildren.add(parameters.type);
        List<Property> properties = this.listProperties(parameters.type);
        this.filterIgnorableProperties(properties, parameters.methodFromPropertyFunction, parameters.shouldIncludeProperty);
        this.correctlyNameProperties(properties, parameters.methodFromPropertyFunction);
        properties.forEach(prop -> this.logger.debug("Property " + prop.getName() + " -> " + prop.getPropertyType().getSimpleName()));
        StringBuilder jsonType = new StringBuilder();
        jsonType.append("{\n");
        String propsAsString = properties.stream().map(prop -> "\"" + prop.getName() + "\": " + this.toJson(parameters.deriveParameters(prop.getPropertyType(), (Property)prop, (List<Class<?>>)typesToExcludeForChildren))).collect(Collectors.joining(",\n"));
        jsonType.append(propsAsString);
        jsonType.append("\n}");
        String result = jsonType.toString();
        Type genericType = (Type)parameters.genericTypeFromPropertyFunction.apply(parameters.property);
        if (!(genericType instanceof ParameterizedType)) {
            parameters.cacheOfTypes.put(parameters.type, result);
        }
        return result;
    }

    private void filterIgnorableProperties(List<Property> properties, Function<Property, Method> methodToCheck, Predicate<Property> shouldInclude) {
        Iterator<Property> iter = properties.iterator();
        while (iter.hasNext()) {
            Property property = iter.next();
            Method method = methodToCheck.apply(property);
            boolean shouldBeIgnored = false;
            if (!shouldInclude.test(property)) {
                shouldBeIgnored = true;
            }
            if (!shouldBeIgnored && method != null) {
                boolean bl = shouldBeIgnored = this.reflectionService.getAnnotation(method, "com.fasterxml.jackson.annotation.JsonIgnore").map(this::getValueFromAnnotation).orElse(false) != false || this.reflectionService.getAnnotation(method, "java.beans.Transient").map(this::getValueFromAnnotation).orElse(false) != false;
            }
            if (!shouldBeIgnored && property.getField() != null) {
                int fieldModifiers = property.getField().getModifiers();
                boolean bl = shouldBeIgnored = Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers) || this.reflectionService.getAnnotation(property.getField(), "com.fasterxml.jackson.annotation.JsonIgnore").map(this::getValueFromAnnotation).orElse(false) != false;
            }
            if (!shouldBeIgnored) continue;
            iter.remove();
        }
    }

    private void correctlyNameProperties(List<Property> properties, Function<Property, Method> methodToCheck) {
        String jsonPropertyAnnotationName = "com.fasterxml.jackson.annotation.JsonProperty";
        properties.forEach(property -> {
            Method method = (Method)methodToCheck.apply((Property)property);
            String customName = null;
            if (method != null) {
                customName = this.reflectionService.getAnnotation(method, jsonPropertyAnnotationName).flatMap(annotation -> this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value")).map(obj -> (String)obj).orElse("");
            }
            if ((customName == null || customName.isEmpty()) && property.getField() != null) {
                customName = this.reflectionService.getAnnotation(property.getField(), jsonPropertyAnnotationName).flatMap(annotation -> this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value")).map(obj -> (String)obj).orElse("");
            }
            if (customName != null && !customName.isEmpty()) {
                property.setCustomName(customName);
            }
        });
    }

    private List<Property> listProperties(Class<?> type) {
        Method[] methods = type.getMethods();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method i : methods) {
            String name;
            if (i.getName().equals("getClass")) continue;
            if (i.getName().startsWith("get") && i.getName().length() > 3 && i.getParameterCount() == 0 && i.getReturnType() != Void.TYPE) {
                name = Character.toLowerCase(i.getName().charAt(3)) + i.getName().substring(4);
                getters.put(name, i);
                continue;
            }
            if (i.getName().startsWith("is") && i.getName().length() > 3 && i.getParameterCount() == 0 && i.getReturnType() == Boolean.TYPE) {
                name = Character.toLowerCase(i.getName().charAt(2)) + i.getName().substring(3);
                getters.put(name, i);
                continue;
            }
            if (!i.getName().startsWith("set") || i.getName().length() <= 3 || i.getParameterCount() != 1) continue;
            name = Character.toLowerCase(i.getName().charAt(3)) + i.getName().substring(4);
            setters.put(name, i);
        }
        Map<String, Field> fields = Arrays.stream(type.getDeclaredFields()).collect(Collectors.toMap(Field::getName, f -> f));
        ArrayList<Property> properties = new ArrayList<Property>();
        HashSet names = new HashSet(getters.keySet());
        names.addAll(setters.keySet());
        for (String name : names) {
            Class<?> st;
            Method get = (Method)getters.get(name);
            Method set = (Method)setters.get(name);
            Field field2 = fields.get(name);
            if (get == null) {
                properties.add(new Property(name, get, set, field2, set.getParameterTypes()[0]));
                continue;
            }
            if (set == null) {
                properties.add(new Property(name, get, set, field2, get.getReturnType()));
                continue;
            }
            Class<?> gt = get.getReturnType();
            if (gt == (st = set.getParameterTypes()[0])) {
                properties.add(new Property(name, get, set, field2, gt));
                continue;
            }
            if (gt.isAssignableFrom(st)) {
                properties.add(new Property(name, get, set, field2, gt));
                continue;
            }
            if (!st.isAssignableFrom(gt)) continue;
            properties.add(new Property(name, get, set, field2, st));
        }
        Arrays.stream(type.getDeclaredFields()).filter(field -> !names.contains(field.getName())).filter(field -> Modifier.isPublic(field.getModifiers())).forEach(field -> properties.add(new Property(field.getName(), null, null, (Field)field, field.getType())));
        return properties;
    }

    private boolean isObject(Class<?> type) {
        return type.getName().equals(Object.class.getName()) || Map.class.isAssignableFrom(type);
    }

    private boolean isCollection(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || type.isArray();
    }

    private boolean isHttpEntity(Class<?> type) {
        for (Class<?> aClass = type; aClass != null; aClass = aClass.getSuperclass()) {
            if (!aClass.getName().equals("org.springframework.http.HttpEntity")) continue;
            return true;
        }
        return false;
    }

    private boolean isDeferredResult(Class<?> type) {
        for (Class<?> aClass = type; aClass != null; aClass = aClass.getSuperclass()) {
            if (!aClass.getName().equals("org.springframework.web.context.request.async.DeferredResult") && !aClass.getName().equals("org.springframework.web.context.request.async.WebAsyncTask") && !aClass.getName().equals("java.util.concurrent.Callable") && !aClass.getName().equals("reactor.core.publisher.Mono") && !aClass.getName().equals("reactor.core.publisher.Flux") && !aClass.getName().equals("java.util.concurrent.CompletableFuture")) continue;
            return true;
        }
        return false;
    }

    private boolean isPrimitive(Class<?> type) {
        if (type.isEnum()) {
            return true;
        }
        HashSet<String> primitiveTypes = new HashSet<String>();
        primitiveTypes.addAll(stringPrimitives);
        primitiveTypes.addAll(numberPrimitives);
        primitiveTypes.addAll(booleanPrimitives);
        return primitiveTypes.contains(type.getName());
    }

    private String getHttpEntityJsonType(Class<?> type, Type genericType, List<Class<?>> typesToExcludeToPreventLoop, Parameters parameters) {
        if (genericType instanceof ParameterizedType) {
            return this.getParameterizedTypeJsonType((ParameterizedType)genericType, typesToExcludeToPreventLoop, parameters);
        }
        return "object";
    }

    private String getCollectionJsonType(Class<?> type, Type genericType, List<Class<?>> typesToExcludeToPreventLoop, Parameters parameters) {
        if (type.isArray()) {
            return "[\n" + this.toJson(parameters.deriveParameters(type.getComponentType(), null, typesToExcludeToPreventLoop)) + "\n]";
        }
        if (genericType instanceof ParameterizedType) {
            return "[\n" + this.getParameterizedTypeJsonType((ParameterizedType)genericType, typesToExcludeToPreventLoop, parameters) + "\n]";
        }
        this.logger.warn("Unmapable collection type: " + type.getName());
        return "[\nobject\n]";
    }

    private String getParameterizedTypeJsonType(ParameterizedType genericType, List<Class<?>> typesToExcludeToPreventLoop, Parameters parameters) {
        Type[] typeArguments = genericType.getActualTypeArguments();
        if (typeArguments.length > 0) {
            if (typeArguments[0] instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)typeArguments[0];
                if (this.isCollection((Class)paramType.getRawType())) {
                    return this.getCollectionJsonType((Class)paramType.getRawType(), paramType, typesToExcludeToPreventLoop, parameters);
                }
                this.logger.warn("Unable to get nested parameterizedtype for " + paramType.getTypeName());
                return "object";
            }
            if (typeArguments[0] instanceof WildcardType) {
                return "object";
            }
            if (typeArguments[0] instanceof Class) {
                return this.toJson(parameters.deriveParameters((Class)typeArguments[0], null, typesToExcludeToPreventLoop));
            }
            if (typeArguments[0] instanceof TypeVariable) {
                Type parentTypeWithTypeVar;
                if (parameters.parentParameters != null && (parentTypeWithTypeVar = (Type)parameters.parentParameters.genericTypeFromPropertyFunction.apply(parameters.parentParameters.property)) instanceof ParameterizedType) {
                    return this.getParameterizedTypeJsonType((ParameterizedType)parentTypeWithTypeVar, typesToExcludeToPreventLoop, parameters);
                }
                this.logger.warn("Unable to get type variable for " + parameters.property);
                return "object";
            }
            this.logger.warn("Unsupported parameterizedtype for " + typeArguments[0].getTypeName());
            return "object";
        }
        this.logger.warn("Unable to get actual type parameter for " + genericType.getTypeName());
        return "object";
    }

    private String getPrimitiveJsonType(Class<?> type) {
        String typeName = type.getName();
        if (stringPrimitives.contains(typeName)) {
            return "string";
        }
        if (numberPrimitives.contains(typeName)) {
            return "number";
        }
        if (booleanPrimitives.contains(typeName)) {
            return "boolean";
        }
        this.logger.warn("Unknown primitive type? " + type.getName());
        return "string";
    }

    private boolean getValueFromAnnotation(Annotation annotation) {
        return this.reflectionService.getAnnotationFieldValue(annotation, "value").map(o -> (Boolean)o).orElse(false);
    }

    private boolean isVoidType(Class<?> type) {
        return type == null || Void.TYPE.equals(type) || Void.class.equals(type);
    }

    private static class Parameters {
        private Parameters parentParameters;
        private Class<?> type;
        private Property property;
        private List<Class<?>> typesToExcludeToPreventLoop;
        private Function<Property, Method> methodFromPropertyFunction;
        private Function<Property, Type> genericTypeFromPropertyFunction;
        private Predicate<Property> shouldIncludeProperty;
        private Map<Class, String> cacheOfTypes;

        private Parameters() {
        }

        Parameters deriveParameters(Class<?> childType, Property childProperty, List<Class<?>> childTypesToExclude) {
            Parameters derived = new Parameters();
            derived.parentParameters = this;
            derived.type = childType;
            derived.property = childProperty;
            derived.typesToExcludeToPreventLoop = childTypesToExclude;
            derived.shouldIncludeProperty = this.shouldIncludeProperty;
            derived.methodFromPropertyFunction = this.methodFromPropertyFunction;
            derived.genericTypeFromPropertyFunction = this.genericTypeFromPropertyFunction;
            derived.cacheOfTypes = this.cacheOfTypes;
            return derived;
        }
    }

    public static interface ObjectToJsonReflection {
        public Optional<Object> getAnnotationFieldValue(Annotation var1, String var2);

        public Optional<Annotation> getAnnotation(Method var1, String var2);

        public Optional<Annotation> getAnnotation(Field var1, String var2);
    }

    public static interface ObjectToJsonLogger {
        public void debug(CharSequence var1);

        public void info(CharSequence var1);

        public void warn(CharSequence var1);
    }
}

