/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import io.contextmap.core.reflection.ObjectToJsonConverter;
import io.contextmap.core.reflection.Property;
import io.contextmap.model.json.ScannedJsonNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class SwaggerV2 {
    private final ObjectToJsonConverter.ObjectToJsonReflection reflectionService;

    public SwaggerV2(ObjectToJsonConverter.ObjectToJsonReflection reflectionService) {
        this.reflectionService = reflectionService;
    }

    public boolean enrichWithApiModelPropertyAnnotationIfAvailable(Property property, Function<Property, Method> methodToCheck, ScannedJsonNode propertyJsonNode) {
        Optional<Annotation> annotation;
        String annotationFQN = "io.swagger.annotations.ApiModelProperty";
        Method method = methodToCheck.apply(property);
        Consumer<Annotation> enricher = ann -> {
            this.reflectionService.getAnnotationFieldValue((Annotation)ann, "value").filter(str -> !((String)str).isEmpty()).ifPresent(description -> propertyJsonNode.setDescription((String)description));
            this.reflectionService.getAnnotationFieldValue((Annotation)ann, "example").filter(str -> !((String)str).isEmpty()).ifPresent(example -> propertyJsonNode.setExample((String)example));
        };
        if (method != null && (annotation = this.reflectionService.getAnnotation(method, annotationFQN)).isPresent()) {
            enricher.accept(annotation.get());
            return true;
        }
        if (property.getField() != null && (annotation = this.reflectionService.getAnnotation(property.getField(), annotationFQN)).isPresent()) {
            enricher.accept(annotation.get());
            return true;
        }
        return false;
    }
}

