/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ReflectionFunctions {
    public static Optional<Annotation> getAnnotation(Class<?> type, String annotationFullyQualifiedName) {
        return Arrays.stream(type.getAnnotations()).filter(a -> a.annotationType().getName().equals(annotationFullyQualifiedName)).findFirst();
    }

    public static Optional<Annotation> getAnnotation(Method method, String annotationFullyQualifiedName) {
        return Arrays.stream(method.getAnnotations()).filter(a -> a.annotationType().getName().equals(annotationFullyQualifiedName)).findFirst();
    }

    public static Optional<Annotation> getAnnotation(Field field, String annotationFullyQualifiedName) {
        return Arrays.stream(field.getAnnotations()).filter(a -> a.annotationType().getName().equals(annotationFullyQualifiedName)).findFirst();
    }

    public static Map<Parameter, Annotation> getArgumentsWithAnnotation(Method method, String annotationFullyQualifiedName) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Parameter[] parameters = method.getParameters();
        HashMap<Parameter, Annotation> parametersWithAnnotation = new HashMap<Parameter, Annotation>();
        for (int i = 0; i < parameters.length; ++i) {
            int index = i;
            Arrays.stream(parameterAnnotations[i]).filter(a -> a.annotationType().getName().equals(annotationFullyQualifiedName)).findFirst().ifPresent(annotation -> parametersWithAnnotation.put(parameters[index], (Annotation)annotation));
        }
        return parametersWithAnnotation;
    }

    public static Optional<Object> getAnnotationFieldValue(Annotation annotation, String fieldName) {
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        return Arrays.stream(methods).filter(f -> fieldName.equals(f.getName())).findFirst().map(f -> {
            try {
                return f.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        });
    }
}

