/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.model.json;

import io.contextmap.model.json.NodeType;
import io.contextmap.model.json.ScannedContainerNode;
import io.contextmap.model.json.ScannedJsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ScannedObjectNode
extends ScannedContainerNode {
    private List<ScannedObjectNodeProperty> properties = new ArrayList<ScannedObjectNodeProperty>();

    @Override
    public NodeType getNodeType() {
        return NodeType.OBJECT;
    }

    public ScannedObjectNodeProperty addProperty(String key, ScannedJsonNode node) {
        ScannedObjectNodeProperty prop = new ScannedObjectNodeProperty();
        prop.setKey(key);
        prop.setValue(node);
        this.properties.add(prop);
        return prop;
    }

    public boolean contains(String key) {
        return this.properties.stream().anyMatch(p -> p.getKey().equals(key));
    }

    public ScannedObjectNodeProperty getProperty(String key) {
        return this.properties.stream().filter(p -> p.getKey().equals(key)).findFirst().orElse(null);
    }

    public List<ScannedObjectNodeProperty> getProperties() {
        return this.properties;
    }

    @Override
    public String toJsonString() {
        ArrayList<String> propertiesAsString = new ArrayList<String>();
        for (ScannedObjectNodeProperty entry : this.properties) {
            propertiesAsString.add(entry.getKey() + ": " + entry.getValue().toJsonString());
        }
        String body = propertiesAsString.stream().collect(Collectors.joining(","));
        return "{" + body + "}";
    }

    public static class ScannedObjectNodeProperty {
        private String key;
        private ScannedJsonNode value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public ScannedJsonNode getValue() {
            return this.value;
        }

        public void setValue(ScannedJsonNode value) {
            this.value = value;
        }
    }
}

