/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.contextmap.spring.runtime.http.Parameters;
import io.contextmap.spring.runtime.http.SigninRequest;
import io.contextmap.spring.runtime.http.SigninResponse;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendClient {
    private static Logger logger = LoggerFactory.getLogger(SendClient.class);
    private static final String MEDIATYPE_JSON = "application/json";
    private static final String MEDIATYPE_JSON_UTF8 = "application/json;charset=UTF-8";
    private final String host;
    private final ObjectMapper objectMapper = this.createObjectMapper();
    private final Parameters parameters;

    public SendClient(ScanApplicationContext applicationContext) {
        this.host = "https://contextmap-server.azurewebsites.net";
        this.parameters = applicationContext.getParameters();
    }

    public boolean send(Scan data) {
        try {
            SigninResponse signinResponse = this.signIn();
            this.sendScan(data, signinResponse);
            return true;
        }
        catch (Exception e) {
            logger.error("Unable to send scanned metadata", (Throwable)e);
            return false;
        }
    }

    private SigninResponse signIn() throws Exception {
        String url = this.host + "/api/auth/signin";
        SigninRequest request = new SigninRequest(this.parameters.getUsername(), this.parameters.getPassword());
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost httpPost = new HttpPost(url);
            String requestAsString = this.objectMapper.writeValueAsString((Object)request);
            StringEntity entity = new StringEntity(requestAsString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", MEDIATYPE_JSON);
            httpPost.setHeader("Content-type", MEDIATYPE_JSON_UTF8);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                throw new RuntimeException("Signin failed, status: " + statusCode);
            }
            SigninResponse signinResponse = this.convertResponseToEntity(response, SigninResponse.class);
            return signinResponse;
        }
    }

    private void sendScan(Scan scan, SigninResponse signinResponse) throws Exception {
        String url = this.host + "/scans";
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost httpPost = new HttpPost(url);
            String requestAsString = this.objectMapper.writeValueAsString((Object)scan);
            StringEntity entity = new StringEntity(requestAsString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", MEDIATYPE_JSON);
            httpPost.setHeader("Content-type", MEDIATYPE_JSON_UTF8);
            httpPost.setHeader("Authorization", "Bearer " + signinResponse.getJwt());
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                HttpEntity responseEntity = response.getEntity();
                String responseString = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8) : "No reason given";
                throw new RuntimeException("Sending failed, status: " + statusCode + ", reason: " + responseString);
            }
        }
    }

    private <T> T convertResponseToEntity(CloseableHttpResponse response, Class<T> type) throws Exception {
        HttpEntity responseEntity = response.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
        return (T)this.objectMapper.readValue(responseString, type);
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        return objectMapper;
    }
}

