/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.solr;

import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.Storage;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.data.solr.core.SolrTemplate;

public class SolrStorageScanner
extends AbstractRuntimeScanner {
    private final ScanApplicationContext context;

    public SolrStorageScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        data.getExecution().setScannedStorages(true);
        List<Storage> storages = this.getSolrStorages();
        data.addStorages(storages);
    }

    private List<Storage> getSolrStorages() {
        Map<String, ?> templates = this.context.getBeansOfType("org.springframework.data.solr.core.SolrTemplate");
        if (templates.isEmpty()) {
            return Collections.emptyList();
        }
        return templates.values().stream().map(this::convertToStorage).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Storage> convertToStorage(SolrTemplate template) {
        SolrClient client = template.getSolrClient();
        String dbName = null;
        if (client instanceof HttpSolrClient) {
            HttpSolrClient httpSolrClient = (HttpSolrClient)client;
            dbName = httpSolrClient.getBaseURL();
        }
        if (dbName == null || dbName.isEmpty()) {
            dbName = "solr-no-name";
        }
        Storage storage = new Storage();
        storage.setName(dbName);
        storage.addProperty("Name", "Solr");
        return Optional.of(storage);
    }
}

