/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.elastic;

import io.contextmap.spring.runtime.ScanAtStartup;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.Storage;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticStorageScanner
extends AbstractRuntimeScanner {
    private final ScanApplicationContext context;

    public ElasticStorageScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        data.getExecution().setScannedStorages(true);
        List<Storage> storages = this.getStoragesFromHighLevelClients();
        if (storages.isEmpty()) {
            storages = this.getStoragesFromRestClients();
        }
        data.addStorages(storages);
    }

    private List<Storage> getStoragesFromHighLevelClients() {
        String fullyQualifiedName = "org.elasticsearch.client.RestHighLevelClient";
        if (!ScanAtStartup.isClassAvailable(fullyQualifiedName)) {
            return Collections.emptyList();
        }
        Map<String, ?> clients = this.context.getBeansOfType(fullyQualifiedName);
        if (clients.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Storage> storages = new ArrayList<Storage>();
        clients.values().stream().findFirst().ifPresent(client -> {
            try {
                Storage storage = new Storage();
                storage.addProperty("Name", "Elastic");
                Field restClientField = RestHighLevelClient.class.getDeclaredField("client");
                restClientField.setAccessible(true);
                RestClient restClient = (RestClient)restClientField.get(client);
                restClient.getNodes().forEach(n -> storage.setName(n.getHost().toURI()));
                storages.add(storage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return storages;
    }

    private List<Storage> getStoragesFromRestClients() {
        String fullyQualifiedName = "org.elasticsearch.client.RestClient";
        if (!ScanAtStartup.isClassAvailable(fullyQualifiedName)) {
            return Collections.emptyList();
        }
        Map<String, ?> clients = this.context.getBeansOfType(fullyQualifiedName);
        if (clients.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Storage> storages = new ArrayList<Storage>();
        clients.values().stream().findFirst().ifPresent(restClient -> {
            try {
                Storage storage = new Storage();
                storage.addProperty("Name", "Elastic");
                ((RestClient)restClient).getNodes().forEach(n -> storage.setName(n.getHost().toURI()));
                storages.add(storage);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return storages;
    }
}

