/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.jdbc;

import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.Storage;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageScanner
extends AbstractRuntimeScanner {
    private static Logger logger = LoggerFactory.getLogger(JdbcStorageScanner.class);
    private final ScanApplicationContext context;

    public JdbcStorageScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        data.getExecution().setScannedStorages(true);
        List<Storage> storages = this.getDataSources();
        data.addStorages(storages);
    }

    private List<Storage> getDataSources() {
        Map<String, ?> beanMap = this.context.getBeansOfType("javax.sql.DataSource");
        if (beanMap.isEmpty()) {
            return Collections.emptyList();
        }
        return beanMap.values().stream().map(this::convertToStorage).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Storage> convertToStorage(DataSource dataSource) {
        try (Connection con = dataSource.getConnection();){
            Storage storage = new Storage();
            String name = Stream.of(this.getConnectionCatalog(con), this.getConnectionSchema(con)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("/"));
            if (name == null || name.isEmpty()) {
                name = con.getMetaData().getURL();
            }
            if (name == null || name.isEmpty()) {
                Optional<Storage> optional2 = Optional.empty();
                return optional2;
            }
            storage.setName(name);
            storage.addProperty("Name", con.getMetaData().getDatabaseProductName());
            storage.addProperty("Version", con.getMetaData().getDatabaseProductVersion());
            storage.addProperty("Username", con.getMetaData().getUserName());
            storage.addProperty("URL", con.getMetaData().getURL());
            Optional<Storage> optional = Optional.of(storage);
            return optional;
        }
        catch (Exception e) {
            logger.debug("Error while scanning datasource", (Throwable)e);
            return Optional.empty();
        }
    }

    private String getConnectionCatalog(Connection con) {
        try {
            return con.getCatalog();
        }
        catch (Throwable t) {
            return "";
        }
    }

    private String getConnectionSchema(Connection con) {
        try {
            return con.getSchema();
        }
        catch (Throwable t) {
            return "";
        }
    }
}

