/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.events;

import io.contextmap.core.reflection.ObjectToJsonConverter;
import io.contextmap.core.reflection.Property;
import io.contextmap.core.reflection.ReflectionFunctions;
import io.contextmap.model.json.ScannedJsonNode;
import io.contextmap.spring.runtime.model.Event;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFunctions {
    private static Logger logger = LoggerFactory.getLogger(EventFunctions.class);

    public static void addPayloadsToEvents(Map<Class<?>, Set<String>> eventClassToPublishers, Map<String, Event> publishedEvents) {
        eventClassToPublishers.forEach((eventClass, exchangeNames) -> {
            Property property = new Property("", null, null, null, eventClass);
            List typesToExcludeToPreventLoop = Collections.emptyList();
            ObjectToJsonConverter.ObjectToJsonReflection objectToJsonReflection = new ObjectToJsonConverter.ObjectToJsonReflection(){

                public Optional<Object> getAnnotationFieldValue(Annotation annotation, String fieldName) {
                    return ReflectionFunctions.getAnnotationFieldValue((Annotation)annotation, (String)fieldName);
                }

                public Optional<Annotation> getAnnotation(Method method, String annotationFullyQualifiedName) {
                    return ReflectionFunctions.getAnnotation((Method)method, (String)annotationFullyQualifiedName);
                }

                public Optional<Annotation> getAnnotation(Field field, String annotationFullyQualifiedName) {
                    return ReflectionFunctions.getAnnotation((Field)field, (String)annotationFullyQualifiedName);
                }
            };
            ObjectToJsonConverter.ObjectToJsonLogger objectToJsonLogger = new ObjectToJsonConverter.ObjectToJsonLogger(){

                public void debug(CharSequence message) {
                    logger.debug(message.toString());
                }

                public void info(CharSequence message) {
                    logger.info(message.toString());
                }

                public void warn(CharSequence message) {
                    logger.warn(message.toString());
                }
            };
            ObjectToJsonConverter converter = new ObjectToJsonConverter(objectToJsonReflection, objectToJsonLogger);
            ScannedJsonNode resulingJson = converter.serializedJson(eventClass, property, typesToExcludeToPreventLoop);
            exchangeNames.forEach(exchangeName -> {
                Event eventForExchange = (Event)publishedEvents.get(exchangeName);
                if (eventForExchange != null) {
                    eventForExchange.getPayloadsAsJsonNode().add(resulingJson);
                } else {
                    Event missingEvent = new Event((String)exchangeName);
                    missingEvent.getPayloadsAsJsonNode().add(resulingJson);
                    publishedEvents.put((String)exchangeName, missingEvent);
                }
            });
        });
    }
}

