/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.contextmap;

import io.contextmap.annotations.storage.ContextStorage;
import io.contextmap.spring.runtime.model.Scan;
import io.contextmap.spring.runtime.model.ScanApplicationContext;
import io.contextmap.spring.runtime.model.storage.Storage;
import io.contextmap.spring.runtime.model.storage.StorageType;
import io.contextmap.spring.runtime.reflection.AnnotatedTypeScanner;
import io.contextmap.spring.runtime.reflection.AnnotationFunctions;
import io.contextmap.spring.runtime.scanner.AbstractRuntimeScanner;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextStorageScanner
extends AbstractRuntimeScanner {
    private final ScanApplicationContext context;
    private static Logger logger = LoggerFactory.getLogger(ContextStorageScanner.class);

    public ContextStorageScanner(ScanApplicationContext context) {
        this.context = context;
    }

    @Override
    public void scan(Scan data) {
        data.getExecution().setScannedStorages(true);
        AnnotatedTypeScanner typeScanner = new AnnotatedTypeScanner(ContextStorage.class);
        Set<Class<?>> typesAnnotatedWithContextStorage = typeScanner.findTypes(this.context.getComponentScanPackages());
        List<Storage> storages = typesAnnotatedWithContextStorage.stream().map(type -> this.mapType((Class<?>)type).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        data.addStorages(storages);
    }

    private Optional<Storage> mapType(Class<?> type) {
        Optional<Annotation> optionalAnnotation = AnnotationFunctions.getAnnotation(type, ContextStorage.class.getName());
        String name = optionalAnnotation.flatMap(annotation -> AnnotationFunctions.getAnnotationFieldValue(annotation, "name")).orElse(null);
        ContextStorage.StorageType storageType = optionalAnnotation.flatMap(annotation -> AnnotationFunctions.getAnnotationFieldValue(annotation, "type")).orElse(null);
        if (name == null || name.isEmpty()) {
            return Optional.empty();
        }
        Storage storage = new Storage();
        storage.setName(this.context.resolveSpELStringValue(name));
        if (storageType != null) {
            try {
                storage.setType(StorageType.valueOf(storageType.name()));
            }
            catch (Exception e) {
                logger.info("Unable to scan storage type due to unknown type " + storageType.name());
            }
        }
        return Optional.of(storage);
    }
}

